/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.io.File;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.query.dsl.embedded.QueryDslConditionsTest;
import org.infinispan.query.helper.StaticTestingErrorHandler;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.embedded.FilesystemQueryDslConditionsTest")
public class FilesystemQueryDslConditionsTest
extends QueryDslConditionsTest {
    private final String indexDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)this.indexDirectory);
        boolean created = new File(this.indexDirectory).mkdirs();
        AssertJUnit.assertTrue((boolean)created);
        ConfigurationBuilder cfg = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        cfg.indexing().enable().storage(IndexStorage.FILESYSTEM).path(this.indexDirectory).addIndexedEntity(this.getModelFactory().getUserImplClass()).addIndexedEntity(this.getModelFactory().getAccountImplClass()).addIndexedEntity(this.getModelFactory().getTransactionImplClass()).addProperty("hibernate.search.background_failure_handler", StaticTestingErrorHandler.class.getName());
        this.createClusteredCaches(1, cfg);
    }

    @AfterClass
    protected void destroy() {
        try {
            super.destroy();
        }
        finally {
            Util.recursiveFileRemove((String)this.indexDirectory);
        }
    }
}

