/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.util.Sets;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.Search;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.impl.SearchQueryParsingResult;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.impl.QueryCacheEmbeddedTest")
@CleanupAfterMethod
public class QueryCacheEmbeddedTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity(UserHS.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    public void testQueryCache() {
        UserHS user = new UserHS();
        user.setId(1);
        user.setName("John");
        this.cache.put((Object)("user_" + user.getId()), (Object)user);
        QueryCache queryCache = ComponentRegistryUtils.getQueryCache((Cache)this.cache);
        queryCache.get("someCacheName", "someQueryString", null, (Object)"typeDiscriminator", (queryString, acc) -> queryString);
        queryCache.clear();
        Cache internalCache = (Cache)TestingUtil.extractField(QueryCache.class, (Object)queryCache, (String)"lazyCache");
        String queryString2 = "from org.infinispan.query.dsl.embedded.testdomain.hsearch.UserHS u where u.name = 'John'";
        int[] invoked = new int[]{0};
        IckleParsingResult created = (IckleParsingResult)queryCache.get(this.cache.getName(), queryString2, null, IckleParsingResult.class, (qs, acc) -> {
            invoked[0] = invoked[0] + 1;
            return null;
        });
        AssertJUnit.assertEquals((int)1, (int)invoked[0]);
        AssertJUnit.assertNull((Object)created);
        AssertJUnit.assertEquals((int)0, (int)internalCache.size());
        Query query = Search.getQueryFactory((Cache)this.cache).create(queryString2);
        query.execute().list();
        AssertJUnit.assertEquals((int)2, (int)internalCache.size());
        Set cacheValueClasses = (Set)internalCache.values().stream().map(Object::getClass).collect(Collectors.toSet());
        LinkedHashSet expectedCachedValueClasses = Sets.newLinkedHashSet((Object[])new Class[]{IckleParsingResult.class, SearchQueryParsingResult.class});
        AssertJUnit.assertEquals((Object)expectedCachedValueClasses, (Object)cacheValueClasses);
        IckleParsingResult cached = (IckleParsingResult)queryCache.get(this.cache.getName(), queryString2, null, IckleParsingResult.class, (qs, acc) -> {
            throw new AssertionError((Object)"QueryCreator should not be invoked now");
        });
        AssertJUnit.assertNotNull((Object)cached);
    }
}

