/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.infinispan.AdvancedCache;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;

public final class EntityLoader<E>
implements PojoSelectionEntityLoader<E> {
    private final AdvancedCache<?, E> cache;
    private final LocalQueryStatistics queryStatistics;

    public EntityLoader(AdvancedCache<?, E> cache, LocalQueryStatistics queryStatistics) {
        this.cache = cache;
        this.queryStatistics = queryStatistics;
    }

    public List<E> loadBlocking(List<?> identifiers, Deadline deadline) {
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        int entitiesSize = identifiers.size();
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(entitiesSize);
        for (Object identifier : identifiers) {
            keys.add(this.cache.getKeyDataConversion().fromStorage(identifier));
        }
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        Map values = this.cache.getAll(keys);
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.entityLoaded(System.nanoTime() - start);
        }
        ArrayList result = new ArrayList(entitiesSize);
        for (Object e : keys) {
            result.add(values.get(e));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityLoader that = (EntityLoader)o;
        return Objects.equals(this.cache, that.cache) && Objects.equals(this.queryStatistics, that.queryStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.cache, this.queryStatistics);
    }
}

