/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.metamodel;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.metamodel.ObjectFieldMetamodel;
import org.infinispan.search.mapper.mapping.metamodel.ValueFieldMetamodel;

public class IndexMetamodel
implements JsonSerialization {
    private final String entityName;
    private final String javaClassName;
    private final String indexName;
    private final Map<String, ValueFieldMetamodel> valueFields = new LinkedHashMap<String, ValueFieldMetamodel>();
    private final Map<String, ObjectFieldMetamodel> objectFields = new LinkedHashMap<String, ObjectFieldMetamodel>();

    public IndexMetamodel(SearchIndexedEntity indexedEntity) {
        IndexDescriptor descriptor = indexedEntity.indexManager().descriptor();
        this.entityName = indexedEntity.name();
        this.javaClassName = indexedEntity.javaClass().getName();
        this.indexName = descriptor.hibernateSearchName();
        for (IndexFieldDescriptor field : descriptor.staticFields()) {
            String name = field.relativeName();
            boolean multiValued = field.multiValued();
            boolean multiValuedInRoot = field.multiValuedInRoot();
            if (field.isValueField()) {
                IndexValueFieldDescriptor valueField = field.toValueField();
                IndexValueFieldTypeDescriptor type = valueField.type();
                this.valueFields.put(name, new ValueFieldMetamodel(multiValued, multiValuedInRoot, type));
                continue;
            }
            if (!field.isObjectField()) continue;
            this.objectFields.put(name, new ObjectFieldMetamodel(multiValued, multiValuedInRoot, field.toObjectField()));
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Map<String, ValueFieldMetamodel> getValueFields() {
        return this.valueFields;
    }

    public Map<String, ObjectFieldMetamodel> getObjectFields() {
        return this.objectFields;
    }

    public Json toJson() {
        Json object = Json.object((Object[])new Object[]{"entity-name", Json.make((Object)this.entityName), "java-class", Json.make((Object)this.javaClassName), "index-name", Json.make((Object)this.indexName)});
        if (!this.valueFields.isEmpty()) {
            object.set("value-fields", Json.make(this.valueFields));
        }
        if (!this.objectFields.isEmpty()) {
            object.set("object-fields", Json.make(this.objectFields));
        }
        return object;
    }
}

