/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;

final class CQDelete
extends CQWorker {
    CQDelete() {
    }

    @Override
    CompletionStage<QueryResponse> perform(BitSet segments) {
        this.setFilter(segments);
        if (this.queryDefinition.getFirstResult() != 0 || this.queryDefinition.isCustomMaxResults()) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        SearchQueryBuilder query = this.queryDefinition.getSearchQueryBuilder();
        return this.blockingManager.supplyBlocking(() -> this.fetchIds(query), (Object)this).thenCompose(queryResult -> CompletionStages.performSequentially(queryResult.iterator(), arg_0 -> ((AdvancedCache)this.cache).removeAsync(arg_0), Collectors.summingInt(prev -> prev != null ? 1 : 0))).thenApply(QueryResponse::new);
    }

    public List<Object> fetchIds(SearchQueryBuilder query) {
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        List result = query.ids().fetchAllHits();
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.localIndexedQueryExecuted(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return result;
    }
}

