/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.logging;

import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CacheBackpressureFullException;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String classNotIndexable$str() {
        return "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    }

    @Override
    public final CacheConfigurationException classNotIndexable(String className) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.classNotIndexable$str(), className));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void keyClassNotFound(String keyClassName, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.keyClassNotFound$str(), (Object)keyClassName);
    }

    protected String keyClassNotFound$str() {
        return "ISPN014001: Could not locate key class %s";
    }

    @Override
    public final void couldNotInstantiateTransformerClass(Class<?> transformer, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotInstantiateTransformerClass$str(), transformer);
    }

    protected String couldNotInstantiateTransformerClass$str() {
        return "ISPN014002: Cannot instantiate Transformer class %s";
    }

    @Override
    public final void registeringQueryInterceptor(String cacheName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeringQueryInterceptor$str(), (Object)cacheName);
    }

    protected String registeringQueryInterceptor$str() {
        return "ISPN014003: Registering Query interceptor for cache %s";
    }

    @Override
    public final void typeIsUsingDefaultTransformer(Class<?> keyClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.typeIsUsingDefaultTransformer$str(), keyClass);
    }

    protected String typeIsUsingDefaultTransformer$str() {
        return "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities, (Object)elapsedMs);
    }

    protected String indexingEntitiesCompleted$str() {
        return "ISPN014014: Reindexed %1$d entities in %2$d ms";
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return "ISPN014015: %1$d documents indexed in %2$d ms";
    }

    @Override
    public final void purgingIndex(String entityType) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.purgingIndex$str(), (Object)entityType);
    }

    protected String purgingIndex$str() {
        return "ISPN014016: Purging instances of '%s' from the index";
    }

    @Override
    public final void flushingIndex(String entityType) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.flushingIndex$str(), (Object)entityType);
    }

    protected String flushingIndex$str() {
        return "ISPN014017: Flushing index '%s'";
    }

    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    }

    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(String cacheName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResumeSuspendedTx$str() {
        return "ISPN014033: Unable to resume suspended transaction %s";
    }

    @Override
    public final CacheException unableToResumeSuspendedTx(Transaction transaction, Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToResumeSuspendedTx$str(), transaction), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToSuspendTx$str() {
        return "ISPN014034: Unable to suspend transaction";
    }

    @Override
    public final CacheException unableToSuspendTx(Throwable cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToSuspendTx$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    }

    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(String s) {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noTransformerForKey$str() {
        return "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    }

    @Override
    public final CacheException noTransformerForKey(String keyClassName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.noTransformerForKey$str(), keyClassName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void settingBooleanQueryMaxClauseCount(String sysPropName, int maxClauseCount) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.settingBooleanQueryMaxClauseCount$str(), (Object)sysPropName, (Object)maxClauseCount);
    }

    protected String settingBooleanQueryMaxClauseCount$str() {
        return "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    }

    @Override
    public final void ignoringBooleanQueryMaxClauseCount(String sysPropName, int maxClauseCount, int currentMaxClauseCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.ignoringBooleanQueryMaxClauseCount$str(), (Object)sysPropName, (Object)maxClauseCount, (Object)currentMaxClauseCount);
    }

    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    }

    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return "ISPN014050: Interrupted while waiting for completions of some batch indexing operations.";
    }

    @Override
    public final CacheException interruptedWhileWaitingForRequestCompletion(Exception cause) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.interruptedWhileWaitingForRequestCompletion$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingEntityFailures$str() {
        return "ISPN014051: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }

    @Override
    public final SearchException massIndexingEntityFailures(long finalFailureCount, EntityReference firstFailureEntity, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String massIndexerIndexingInstance$str() {
        return "ISPN014052: Indexing instance of entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerIndexingInstance(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerIndexingInstance$str(), entityName);
    }

    protected String noTypeIsIndexed$str() {
        return "ISPN014054: Trying to execute query `%1$s`, but no type is indexed on cache.";
    }

    @Override
    public final CacheException noTypeIsIndexed(String ickle) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.noTypeIsIndexed$str(), ickle));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchMappingUnavailable$str() {
        return "ISPN014055: Cannot index entry since the search mapping failed to initialize.";
    }

    @Override
    public final CacheException searchMappingUnavailable() {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.searchMappingUnavailable$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void mappingIsRestarting() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.mappingIsRestarting$str(), new Object[0]);
    }

    protected String mappingIsRestarting$str() {
        return "ISPN014059: The indexing engine is restarting, index updates will be skipped for the current data changes.";
    }

    @Override
    public final void concurrentReindexingOnGetStatistics(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.INFO, cause, this.concurrentReindexingOnGetStatistics$str(), new Object[0]);
    }

    protected String concurrentReindexingOnGetStatistics$str() {
        return "ISPN014060: We're getting some errors from Hibernate Search or Lucene while we compute the index count/size for statistics. There is probably a concurrent reindexing ongoing.";
    }

    protected String cannotLoadIndexedClass$str() {
        return "ISPN014061: Failed to load declared indexed class '%s'";
    }

    @Override
    public final CacheConfigurationException cannotLoadIndexedClass(String name, Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotLoadIndexedClass$str(), name), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void preIndexingReloading() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.preIndexingReloading$str(), new Object[0]);
    }

    protected String preIndexingReloading$str() {
        return "ISPN014062: Search engine is reloaded before the reindexing.";
    }

    @Override
    public final void indexingStarting() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingStarting$str(), new Object[0]);
    }

    protected String indexingStarting$str() {
        return "ISPN014063: Reindexing starting.";
    }

    protected String multipleKnnPredicates$str() {
        return "ISPN014064: Multiple knn predicates are not supported at the moment.";
    }

    @Override
    public final ParsingException multipleKnnPredicates() {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.multipleKnnPredicates$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String booleanKnnPredicates$str() {
        return "ISPN014065: Boolean predicates containing knn predicates are not supported at the moment.";
    }

    @Override
    public final ParsingException booleanKnnPredicates() {
        ParsingException result = new ParsingException(String.format(this.getLoggingLocale(), this.booleanKnnPredicates$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failedToPurgeIndexForSegments(Throwable cause, IntSet removedSegments) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToPurgeIndexForSegments$str(), (Object)removedSegments);
    }

    protected String failedToPurgeIndexForSegments$str() {
        return "ISPN014066: Failed to purge index for segments %s";
    }

    protected String hibernateSearchBackpressure$str() {
        return "ISPN014067: Hibernate Search updates are not keeping up. Look into increasing index writer queue and/or thread pool sizes.";
    }

    @Override
    public final CacheBackpressureFullException hibernateSearchBackpressure() {
        CacheBackpressureFullException result = new CacheBackpressureFullException(String.format(this.getLoggingLocale(), this.hibernateSearchBackpressure$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

