/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.work.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.query.concurrent.InfinispanIndexingExecutorProvider;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.session.impl.InfinispanIndexedTypeContext;
import org.infinispan.search.mapper.session.impl.InfinispanTypeContextProvider;
import org.infinispan.search.mapper.work.SearchIndexer;
import org.infinispan.util.concurrent.BlockingManager;

public class SearchIndexerImpl
implements SearchIndexer {
    private final PojoIndexer delegate;
    private final EntityConverter entityConverter;
    private final InfinispanTypeContextProvider typeContextProvider;
    private final SimpleScheduledExecutor offloadingExecutor;

    public SearchIndexerImpl(PojoIndexer delegate, EntityConverter entityConverter, InfinispanTypeContextProvider typeContextProvider, BlockingManager blockingManager) {
        this.delegate = delegate;
        this.entityConverter = entityConverter;
        this.typeContextProvider = typeContextProvider;
        this.offloadingExecutor = InfinispanIndexingExecutorProvider.writeExecutor(blockingManager);
    }

    @Override
    public CompletableFuture<?> add(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.delegate.add(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.offloading(arg_0 -> ((SimpleScheduledExecutor)this.offloadingExecutor).submit(arg_0)));
    }

    @Override
    public CompletableFuture<?> addOrUpdate(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.delegate.addOrUpdate(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.offloading(arg_0 -> ((SimpleScheduledExecutor)this.offloadingExecutor).submit(arg_0)));
    }

    @Override
    public CompletableFuture<?> delete(Object providedId, String routingKey, Object entity) {
        ConvertedValue convertedValue = this.convertedValue(entity, providedId);
        if (convertedValue == null) {
            return CompletableFutures.completedNull();
        }
        return this.delegate.delete(convertedValue.typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), convertedValue.value, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.offloading(arg_0 -> ((SimpleScheduledExecutor)this.offloadingExecutor).submit(arg_0)));
    }

    @Override
    public CompletableFuture<?> purge(Object providedId, String routingKey) {
        return CompletableFuture.allOf((CompletableFuture[])this.typeContextProvider.allTypeIdentifiers().stream().map(typeIdentifier -> this.delegate.delete(typeIdentifier, providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)routingKey), DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.offloading(arg_0 -> ((SimpleScheduledExecutor)this.offloadingExecutor).submit(arg_0)))).toArray(CompletableFuture[]::new));
    }

    @Override
    public void close() {
    }

    private ConvertedValue convertedValue(Object entity, Object providedId) {
        if (entity == null) {
            return null;
        }
        if (this.entityConverter == null || !this.entityConverter.typeIsIndexed(entity.getClass())) {
            InfinispanIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForExactType(entity.getClass());
            if (typeContext == null) {
                return null;
            }
            return new ConvertedValue(typeContext, entity);
        }
        EntityConverter.ConvertedEntity converted = this.entityConverter.convert(entity, providedId);
        if (converted.skip()) {
            return null;
        }
        InfinispanIndexedTypeContext<?> typeContext = this.typeContextProvider.indexedForEntityName(converted.entityName());
        if (typeContext == null) {
            return null;
        }
        return new ConvertedValue(typeContext, converted.value());
    }

    private static class ConvertedValue {
        private final PojoRawTypeIdentifier<?> typeIdentifier;
        private final Object value;

        public ConvertedValue(InfinispanIndexedTypeContext<?> typeContext, Object value) {
            this.typeIdentifier = typeContext.typeIdentifier();
            this.value = value;
        }
    }
}

