package org.infinispan.query.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.IntSet;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.infinispan.commons.util.concurrent.CacheBackpressureFullException;
import jakarta.transaction.Transaction;
import org.jboss.logging.BasicLogger;
import org.infinispan.objectfilter.ParsingException;
import org.hibernate.search.engine.common.EntityReference;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-08-07T04:31:53-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String classNotIndexable$str() {
        return "ISPN000404: The configured entity class %s is not indexable. Please remove it from the indexing configuration.";
    }
    @Override
    public final CacheConfigurationException classNotIndexable(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), classNotIndexable$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void keyClassNotFound(final String keyClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, keyClassNotFound$str(), keyClassName);
    }
    protected String keyClassNotFound$str() {
        return "ISPN014001: Could not locate key class %s";
    }
    @Override
    public final void couldNotInstantiateTransformerClass(final Class<?> transformer, final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotInstantiateTransformerClass$str(), transformer);
    }
    protected String couldNotInstantiateTransformerClass$str() {
        return "ISPN014002: Cannot instantiate Transformer class %s";
    }
    @Override
    public final void registeringQueryInterceptor(final String cacheName) {
        super.log.logf(FQCN, INFO, null, registeringQueryInterceptor$str(), cacheName);
    }
    protected String registeringQueryInterceptor$str() {
        return "ISPN014003: Registering Query interceptor for cache %s";
    }
    @Override
    public final void typeIsUsingDefaultTransformer(final Class<?> keyClass) {
        super.log.logf(FQCN, WARN, null, typeIsUsingDefaultTransformer$str(), keyClass);
    }
    protected String typeIsUsingDefaultTransformer$str() {
        return "ISPN014009: Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable";
    }
    @Override
    public final void indexingEntitiesCompleted(final long nbrOfEntities, final long elapsedMs) {
        super.log.logf(FQCN, INFO, null, indexingEntitiesCompleted$str(), nbrOfEntities, elapsedMs);
    }
    protected String indexingEntitiesCompleted$str() {
        return "ISPN014014: Reindexed %1$d entities in %2$d ms";
    }
    @Override
    public final void indexingDocumentsCompleted(final long doneCount, final long elapsedMs) {
        super.log.logf(FQCN, DEBUG, null, indexingDocumentsCompleted$str(), doneCount, elapsedMs);
    }
    protected String indexingDocumentsCompleted$str() {
        return "ISPN014015: %1$d documents indexed in %2$d ms";
    }
    @Override
    public final void purgingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, purgingIndex$str(), entityType);
    }
    protected String purgingIndex$str() {
        return "ISPN014016: Purging instances of '%s' from the index";
    }
    @Override
    public final void flushingIndex(final String entityType) {
        super.log.logf(FQCN, INFO, null, flushingIndex$str(), entityType);
    }
    protected String flushingIndex$str() {
        return "ISPN014017: Flushing index '%s'";
    }
    protected String cannotRunLuceneQueriesIfNotIndexed$str() {
        return "ISPN014019: Cannot run Lucene queries on a cache '%s' that does not have indexing enabled";
    }
    @Override
    public final IllegalStateException cannotRunLuceneQueriesIfNotIndexed(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRunLuceneQueriesIfNotIndexed$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResumeSuspendedTx$str() {
        return "ISPN014033: Unable to resume suspended transaction %s";
    }
    @Override
    public final CacheException unableToResumeSuspendedTx(final Transaction transaction, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToResumeSuspendedTx$str(), transaction), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToSuspendTx$str() {
        return "ISPN014034: Unable to suspend transaction";
    }
    @Override
    public final CacheException unableToSuspendTx(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToSuspendTx$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str() {
        return "ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy: %s";
    }
    @Override
    public final ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(final String s) {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), getPrefixWildcardOrRegexpQueriesCannotBeFuzzy$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTransformerForKey$str() {
        return "ISPN014043: Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.";
    }
    @Override
    public final CacheException noTransformerForKey(final String keyClassName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTransformerForKey$str(), keyClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void settingBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount) {
        super.log.logf(FQCN, INFO, null, settingBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount);
    }
    protected String settingBooleanQueryMaxClauseCount$str() {
        return "ISPN014046: Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d";
    }
    @Override
    public final void ignoringBooleanQueryMaxClauseCount(final String sysPropName, final int maxClauseCount, final int currentMaxClauseCount) {
        super.log.logf(FQCN, WARN, null, ignoringBooleanQueryMaxClauseCount$str(), sysPropName, maxClauseCount, currentMaxClauseCount);
    }
    protected String ignoringBooleanQueryMaxClauseCount$str() {
        return "ISPN014047: Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()";
    }
    protected String interruptedWhileWaitingForRequestCompletion$str() {
        return "ISPN014050: Interrupted while waiting for completions of some batch indexing operations.";
    }
    @Override
    public final CacheException interruptedWhileWaitingForRequestCompletion(final Exception cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), interruptedWhileWaitingForRequestCompletion$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexingEntityFailures$str() {
        return "ISPN014051: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }
    @Override
    public final SearchException massIndexingEntityFailures(final long finalFailureCount, final EntityReference firstFailureEntity, final String firstFailureMessage, final Throwable firstFailure) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String massIndexerIndexingInstance$str() {
        return "ISPN014052: Indexing instance of entity '%s' during mass indexing";
    }
    @Override
    public final String massIndexerIndexingInstance(final String entityName) {
        return String.format(getLoggingLocale(), massIndexerIndexingInstance$str(), entityName);
    }
    protected String noTypeIsIndexed$str() {
        return "ISPN014054: Trying to execute query `%1$s`, but no type is indexed on cache.";
    }
    @Override
    public final CacheException noTypeIsIndexed(final String ickle) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), noTypeIsIndexed$str(), ickle));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchMappingUnavailable$str() {
        return "ISPN014055: Cannot index entry since the search mapping failed to initialize.";
    }
    @Override
    public final CacheException searchMappingUnavailable() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), searchMappingUnavailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void mappingIsRestarting() {
        super.log.logf(FQCN, WARN, null, mappingIsRestarting$str());
    }
    protected String mappingIsRestarting$str() {
        return "ISPN014059: The indexing engine is restarting, index updates will be skipped for the current data changes.";
    }
    @Override
    public final void concurrentReindexingOnGetStatistics(final Throwable cause) {
        super.log.logf(FQCN, INFO, cause, concurrentReindexingOnGetStatistics$str());
    }
    protected String concurrentReindexingOnGetStatistics$str() {
        return "ISPN014060: We're getting some errors from Hibernate Search or Lucene while we compute the index count/size for statistics. There is probably a concurrent reindexing ongoing.";
    }
    protected String cannotLoadIndexedClass$str() {
        return "ISPN014061: Failed to load declared indexed class '%s'";
    }
    @Override
    public final CacheConfigurationException cannotLoadIndexedClass(final String name, final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotLoadIndexedClass$str(), name), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void preIndexingReloading() {
        super.log.logf(FQCN, DEBUG, null, preIndexingReloading$str());
    }
    protected String preIndexingReloading$str() {
        return "ISPN014062: Search engine is reloaded before the reindexing.";
    }
    @Override
    public final void indexingStarting() {
        super.log.logf(FQCN, INFO, null, indexingStarting$str());
    }
    protected String indexingStarting$str() {
        return "ISPN014063: Reindexing starting.";
    }
    protected String multipleKnnPredicates$str() {
        return "ISPN014064: Multiple knn predicates are not supported at the moment.";
    }
    @Override
    public final ParsingException multipleKnnPredicates() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), multipleKnnPredicates$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String booleanKnnPredicates$str() {
        return "ISPN014065: Boolean predicates containing knn predicates are not supported at the moment.";
    }
    @Override
    public final ParsingException booleanKnnPredicates() {
        final ParsingException result = new ParsingException(String.format(getLoggingLocale(), booleanKnnPredicates$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToPurgeIndexForSegments(final Throwable cause, final IntSet removedSegments) {
        super.log.logf(FQCN, WARN, cause, failedToPurgeIndexForSegments$str(), removedSegments);
    }
    protected String failedToPurgeIndexForSegments$str() {
        return "ISPN014066: Failed to purge index for segments %s";
    }
    protected String hibernateSearchBackpressure$str() {
        return "ISPN014067: Hibernate Search updates are not keeping up. Look into increasing index writer queue and/or thread pool sizes.";
    }
    @Override
    public final CacheBackpressureFullException hibernateSearchBackpressure() {
        final CacheBackpressureFullException result = new CacheBackpressureFullException(String.format(getLoggingLocale(), hibernateSearchBackpressure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
