/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import org.infinispan.query.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.query.objectfilter.impl.syntax.AndExpr;
import org.infinispan.query.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.query.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.query.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.query.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.query.objectfilter.impl.syntax.KnnPredicate;
import org.infinispan.query.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.query.objectfilter.impl.syntax.NestedExpr;
import org.infinispan.query.objectfilter.impl.syntax.NotExpr;
import org.infinispan.query.objectfilter.impl.syntax.OrExpr;
import org.infinispan.query.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinBoxExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinCircleExpr;
import org.infinispan.query.objectfilter.impl.syntax.SpatialWithinPolygonExpr;
import org.infinispan.query.objectfilter.impl.syntax.Visitor;

public final class IndexedSearchPredicateDetector
implements Visitor<Boolean, Boolean> {
    private static final IndexedSearchPredicateDetector INSTANCE = new IndexedSearchPredicateDetector();

    private IndexedSearchPredicateDetector() {
    }

    public static boolean checkIndexingRequired(BooleanExpr expr) {
        return (Boolean)expr.acceptVisitor(INSTANCE);
    }

    @Override
    public Boolean visit(FullTextOccurExpr fullTextOccurExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FullTextBoostExpr fullTextBoostExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FullTextTermExpr fullTextTermExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FullTextRegexpExpr fullTextRegexpExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FullTextRangeExpr fullTextRangeExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SpatialWithinCircleExpr spatialWithinCircleExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SpatialWithinBoxExpr spatialWithinBoxExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SpatialWithinPolygonExpr spatialWithinPolygonExpr) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(KnnPredicate knnPredicate) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NotExpr notExpr) {
        return (Boolean)notExpr.getChild().acceptVisitor(this);
    }

    @Override
    public Boolean visit(OrExpr orExpr) {
        for (BooleanExpr c : orExpr.getChildren()) {
            if (!((Boolean)c.acceptVisitor(this)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(AndExpr andExpr) {
        for (BooleanExpr c : andExpr.getChildren()) {
            if (!((Boolean)c.acceptVisitor(this)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ConstantBooleanExpr constantBooleanExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(IsNullExpr isNullExpr) {
        return (Boolean)isNullExpr.getChild().acceptVisitor(this);
    }

    @Override
    public Boolean visit(ComparisonExpr comparisonExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(BetweenExpr betweenExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(LikeExpr likeExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(ConstantValueExpr constantValueExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(PropertyValueExpr propertyValueExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(AggregationExpr aggregationExpr) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(NestedExpr nestedExpr) {
        for (BooleanExpr c : nestedExpr.getNestedChildren()) {
            if (!((Boolean)c.acceptVisitor(this)).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

