/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.query.backend.IndexSearcherCloser;
import org.infinispan.query.impl.AbstractIterator;

@NotThreadSafe
public class LazyIterator
extends AbstractIterator {
    private DocumentExtractor extractor;
    private IndexSearcher searcher;
    private SearchFactoryImplementor searchFactory;

    public LazyIterator(DocumentExtractor extractor, Cache cache, IndexSearcher searcher, SearchFactoryImplementor searchFactory, int first, int max, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchsize passed. Your fetchSize is less than 1");
        }
        this.extractor = extractor;
        this.cache = cache;
        this.index = first;
        this.first = first;
        this.max = max;
        this.fetchSize = fetchSize;
        this.searcher = searcher;
        this.searchFactory = searchFactory;
        this.buffer = new Object[this.fetchSize];
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index < this.first || index > this.max) {
            throw new IndexOutOfBoundsException("The given index is incorrect. Please check and try again.");
        }
        this.index = this.first + index;
    }

    @Override
    public void close() {
        IndexSearcherCloser.closeSearcher((Searcher)this.searcher, this.searchFactory.getReaderProvider());
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no next");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index >= this.bufferIndex && this.index < this.bufferIndex + bufferSize) {
            int indexToReturn = this.index - this.bufferIndex;
            toReturn = this.buffer[indexToReturn];
        } else {
            try {
                String documentId = (String)((Object)this.extractor.extract((int)this.index).id);
                toReturn = this.cache.get((Object)documentId);
                Arrays.fill(this.buffer, null);
                this.buffer[0] = toReturn;
                for (int i = 1; i < bufferSize; ++i) {
                    Object toBuffer;
                    String bufferDocumentId = (String)((Object)this.extractor.extract((int)(this.index + i)).id);
                    this.buffer[i] = toBuffer = this.cache.get((Object)bufferDocumentId);
                }
                this.bufferIndex = this.index;
            }
            catch (IOException e) {
                throw new CacheException();
            }
        }
        ++this.index;
        return toReturn;
    }

    public Object previous() {
        if (!this.hasPrevious()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no previous");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index <= this.bufferIndex && this.index >= this.bufferIndex + bufferSize) {
            int indexToReturn = this.bufferIndex - this.index;
            toReturn = this.buffer[indexToReturn];
        }
        try {
            Arrays.fill(this.buffer, null);
            String documentId = (String)((Object)this.extractor.extract((int)this.index).id);
            this.buffer[0] = toReturn = this.cache.get((Object)documentId);
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                String bufferDocumentId = (String)((Object)this.extractor.extract((int)(this.index - i)).id);
                this.buffer[i] = toBuffer = this.cache.get((Object)bufferDocumentId);
            }
            this.bufferIndex = this.index;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        --this.index;
        return toReturn;
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries.");
        }
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }
}

