/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.InterceptorChainFactory;
import org.infinispan.interceptors.DistLockingInterceptor;
import org.infinispan.interceptors.LockingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchFactoryStopper;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryHelper {
    private static final Log log = LogFactory.getLog(QueryHelper.class);
    private Cache cache;
    private Properties properties;
    private Class[] classes;
    private SearchFactoryImplementor searchFactory;

    public QueryHelper(Cache cache, Properties properties, Class ... classes) {
        if (cache.getStatus().needToInitializeBeforeStart()) {
            log.debug((Object)"Cache not started.  Starting cache first.");
            cache.start();
        }
        this.checkInterceptorChain(cache);
        if (classes.length == 0) {
            throw new IllegalArgumentException("You haven't passed in any classes to index.");
        }
        this.validateClasses(classes);
        if (properties == null) {
            log.debug((Object)"Properties is null.");
        }
        this.cache = cache;
        this.properties = properties;
        this.classes = classes;
        SearchableCacheConfiguration config = new SearchableCacheConfiguration(classes, properties);
        this.searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)config).buildSearchFactory();
        this.applyProperties(cache.getConfiguration());
    }

    private void applyProperties(Configuration cfg) {
        log.debug((Object)"Entered QueryHelper.applyProperties()");
        if (cfg.isIndexingEnabled()) {
            try {
                if (cfg.isIndexLocalOnly()) {
                    this.initComponents(cfg, LocalQueryInterceptor.class);
                } else {
                    this.initComponents(cfg, QueryInterceptor.class);
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to add interceptor", (Throwable)e);
            }
        }
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    public Class[] getClasses() {
        return this.classes;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void initComponents(Configuration cfg, Class<? extends QueryInterceptor> interceptorClass) throws IllegalAccessException, InstantiationException {
        ComponentRegistry cr = this.cache.getAdvancedCache().getComponentRegistry();
        cr.registerComponent((Object)this.searchFactory, SearchFactoryImplementor.class);
        cr.registerComponent((Object)new SearchFactoryStopper(this.searchFactory), SearchFactoryStopper.class);
        InterceptorChainFactory icf = (InterceptorChainFactory)cr.getComponent(InterceptorChainFactory.class);
        CommandInterceptor inter = icf.createInterceptor(interceptorClass);
        cr.registerComponent((Object)inter, QueryInterceptor.class);
        this.cache.getAdvancedCache().addInterceptorAfter(inter, cfg.getCacheMode().isDistributed() ? DistLockingInterceptor.class : LockingInterceptor.class);
    }

    private void validateClasses(Class ... classes) {
        for (Class c : classes) {
            if (!c.isAnnotationPresent(ProvidedId.class)) {
                throw new IllegalArgumentException("There is no provided id on " + c.getName() + " class");
            }
            for (Field field : c.getFields()) {
                if (field.getAnnotation(DocumentId.class) == null) continue;
                throw new IllegalArgumentException("Please remove the documentId annotation in " + c.getName());
            }
            for (Field field : c.getDeclaredFields()) {
                if (field.getAnnotation(DocumentId.class) == null) continue;
                throw new IllegalArgumentException("Please remove the documentId annotation in " + c.getName());
            }
        }
    }

    private void checkInterceptorChain(Cache cache) {
        AdvancedCache advanced = cache.getAdvancedCache();
        List interceptorList = advanced.getInterceptorChain();
        for (CommandInterceptor inter : interceptorList) {
            if (!inter.getClass().equals(QueryInterceptor.class) && !inter.getClass().equals(LocalQueryInterceptor.class)) continue;
            throw new CacheException("There is already an instance of the QueryInterceptor running");
        }
    }
}

