/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;

public class CacheQueryImpl
implements CacheQuery {
    private final Cache cache;
    private final HSQuery hSearchQuery;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryIntegrator searchFactory, Cache cache, Class<?> ... classes) {
        this.cache = cache;
        this.hSearchQuery = searchFactory.createHSQuery();
        this.hSearchQuery.luceneQuery(luceneQuery).targetedEntities(Arrays.asList(classes));
    }

    @Override
    public void setFilter(Filter filter) {
        this.hSearchQuery.filter(filter);
    }

    @Override
    public int getResultSize() {
        return this.hSearchQuery.queryResultSize();
    }

    @Override
    public void setSort(Sort sort) {
        this.hSearchQuery.sort(sort);
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
    }

    @Override
    public void setFirstResult(int firstResult) {
        this.hSearchQuery.firstResult(firstResult);
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.hSearchQuery.maxResults(Integer.valueOf(maxResults));
    }

    @Override
    public QueryIterator iterator() throws SearchException {
        return this.iterator(1);
    }

    @Override
    public QueryIterator iterator(int fetchSize) throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        List<Object> keyList = this.fromEntityInfosToKeys(entityInfos);
        return new EagerIterator(keyList, this.cache, fetchSize);
    }

    @Override
    public QueryIterator lazyIterator() {
        return this.lazyIterator(1);
    }

    @Override
    public QueryIterator lazyIterator(int fetchSize) {
        return new LazyIterator(this.hSearchQuery, this.cache, fetchSize);
    }

    @Override
    public List<Object> list() throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        EntityLoader loader = this.getLoader();
        List list = loader.load(entityInfos.toArray(new EntityInfo[entityInfos.size()]));
        return list;
    }

    private EntityLoader getLoader() {
        return new EntityLoader(this.cache);
    }

    private List<Object> fromEntityInfosToKeys(List<EntityInfo> entityInfos) {
        ArrayList<Object> keyList = new ArrayList<Object>(entityInfos.size());
        for (EntityInfo ei : entityInfos) {
            Object cacheKey = KeyTransformationHandler.stringToKey(ei.getId().toString());
            keyList.add(cacheKey);
        }
        return keyList;
    }
}

