/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.SearchException;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.clustered.ClusteredQueryCommand;
import org.infinispan.query.clustered.ClusteredQueryInvoker;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.DistributedLazyIterator;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.impl.CacheQueryImpl;

public class ClusteredCacheQueryImpl
extends CacheQueryImpl {
    private Sort sort;
    private Integer resultSize;
    private final ExecutorService asyncExecutor;

    public ClusteredCacheQueryImpl(Query luceneQuery, SearchFactoryIntegrator searchFactory, ExecutorService asyncExecutor, AdvancedCache cache, Class<?> ... classes) {
        super(luceneQuery, searchFactory, cache, classes);
        this.asyncExecutor = asyncExecutor;
        this.hSearchQuery = searchFactory.createHSQuery().luceneQuery(luceneQuery).targetedEntities(Arrays.asList(classes));
    }

    @Override
    public CacheQuery sort(Sort sort) {
        this.sort = sort;
        return super.sort(sort);
    }

    @Override
    public int getResultSize() {
        if (this.resultSize == null) {
            ClusteredQueryCommand command = ClusteredQueryCommand.getResultSize(this.hSearchQuery, (Cache)this.cache);
            ClusteredQueryInvoker invoker = new ClusteredQueryInvoker((Cache)this.cache, this.asyncExecutor);
            List<QueryResponse> responses = invoker.broadcast(command);
            this.resultSize = 0;
            for (QueryResponse response : responses) {
                this.resultSize = this.resultSize + response.getResultSize();
            }
        }
        return this.resultSize;
    }

    @Override
    public QueryIterator iterator(int fetchSize) throws SearchException {
        ClusteredQueryCommand command = ClusteredQueryCommand.createEagerIterator(this.hSearchQuery, (Cache)this.cache);
        HashMap<UUID, ClusteredTopDocs> topDocsResponses = this.broadcastQuery(command);
        DistributedIterator it = new DistributedIterator(this.sort, fetchSize, this.resultSize, topDocsResponses, this.cache);
        return it;
    }

    @Override
    public QueryIterator lazyIterator(int fetchSize) {
        UUID lazyItId = UUID.randomUUID();
        ClusteredQueryCommand command = ClusteredQueryCommand.createLazyIterator(this.hSearchQuery, (Cache)this.cache, lazyItId);
        HashMap<UUID, ClusteredTopDocs> topDocsResponses = this.broadcastQuery(command);
        DistributedLazyIterator it = new DistributedLazyIterator(this.sort, fetchSize, this.resultSize, lazyItId, topDocsResponses, this.asyncExecutor, this.cache);
        return it;
    }

    private HashMap<UUID, ClusteredTopDocs> broadcastQuery(ClusteredQueryCommand command) {
        ClusteredQueryInvoker invoker = new ClusteredQueryInvoker((Cache)this.cache, this.asyncExecutor);
        HashMap<UUID, ClusteredTopDocs> topDocsResponses = new HashMap<UUID, ClusteredTopDocs>();
        int resultSize = 0;
        List<QueryResponse> responses = invoker.broadcast(command);
        Iterator<QueryResponse> i$ = responses.iterator();
        while (i$.hasNext()) {
            QueryResponse response;
            QueryResponse queryResponse = response = i$.next();
            ClusteredTopDocs topDocs = new ClusteredTopDocs(queryResponse.getTopDocs(), queryResponse.getNodeUUID());
            resultSize += queryResponse.getResultSize();
            topDocs.setNodeAddress(queryResponse.getAddress());
            topDocsResponses.put(queryResponse.getNodeUUID(), topDocs);
        }
        this.resultSize = resultSize;
        return topDocsResponses;
    }

    @Override
    public List<Object> list() throws SearchException {
        QueryIterator iterator = this.iterator();
        ArrayList<Object> values = new ArrayList<Object>();
        while (iterator.hasNext()) {
            values.add(iterator.next());
        }
        return values;
    }
}

