/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;
import org.infinispan.AdvancedCache;
import org.infinispan.query.clustered.ClusteredDoc;
import org.infinispan.query.clustered.ClusteredTopDocs;
import org.infinispan.query.clustered.ISPNEagerTopDocs;
import org.infinispan.query.clustered.ISPNPriorityQueueFactory;
import org.infinispan.query.impl.AbstractIterator;
import org.infinispan.util.ReflectionUtil;

public class DistributedIterator
extends AbstractIterator {
    private int currentIndex = -1;
    private final ArrayList<Object> orderedValues = new ArrayList();
    private final Sort sort;
    private HashMap<UUID, ClusteredTopDocs> topDocsResponses;
    private PriorityQueue hq;
    private final int resultSize;

    public DistributedIterator(Sort sort, int fetchSize, int resultSize, HashMap<UUID, ClusteredTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.sort = sort;
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.cache = cache;
        this.setTopDocs(topDocsResponses);
    }

    private void setTopDocs(HashMap<UUID, ClusteredTopDocs> topDocsResponses) {
        this.topDocsResponses = topDocsResponses;
        if (this.sort != null) {
            SortField[] arr$ = this.sort.getSort();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SortField sf;
                boolean reverse = (Boolean)ReflectionUtil.getValue((Object)(sf = arr$[i$]), (String)"reverse");
                ReflectionUtil.setValue((Object)sf, (String)"reverse", (Object)(!reverse ? 1 : 0));
            }
            this.hq = ISPNPriorityQueueFactory.getFieldDocSortedHitQueue(topDocsResponses.size(), this.sort.getSort());
        } else {
            this.hq = ISPNPriorityQueueFactory.getHitQueue(topDocsResponses.size());
        }
        for (ClusteredTopDocs ctp : topDocsResponses.values()) {
            if (!ctp.hasNext()) continue;
            this.hq.add((Object)ctp.getNext());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        this.currentIndex = index;
    }

    public void add(Object arg0) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        ++this.currentIndex;
        return this.current();
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.currentIndex + 1;
    }

    public Object previous() {
        --this.currentIndex;
        return this.current();
    }

    private Object current() {
        if (this.orderedValues.size() > this.currentIndex) {
            return this.orderedValues.get(this.currentIndex);
        }
        this.loadTo(this.currentIndex);
        return this.orderedValues.get(this.currentIndex);
    }

    private void loadTo(int index) {
        for (int fetched = 0; this.orderedValues.size() <= index || fetched < this.fetchSize; ++fetched) {
            ClusteredDoc scoreDoc = (ClusteredDoc)this.hq.pop();
            if (scoreDoc == null) {
                return;
            }
            ClusteredTopDocs topDoc = this.topDocsResponses.get(scoreDoc.getNodeUuid());
            ScoreDoc score = topDoc.getNext();
            if (score != null) {
                this.hq.add((Object)score);
            }
            Object value = this.fetchValue(scoreDoc, topDoc);
            this.orderedValues.add(value);
        }
    }

    protected Object fetchValue(ClusteredDoc scoreDoc, ClusteredTopDocs topDoc) {
        ISPNEagerTopDocs eagerTopDocs = (ISPNEagerTopDocs)topDoc.getTopDocs();
        return this.cache.get(eagerTopDocs.keys[scoreDoc.getIndex()]);
    }

    @Override
    public int previousIndex() {
        return this.currentIndex - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    public void set(Object arg0) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex + 1 < this.resultSize;
    }
}

