/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.UUID;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.clustered.QueryBox;
import org.infinispan.query.clustered.QueryResponse;

public abstract class ClusteredQueryCommandWorker {
    protected Cache cache;
    private QueryBox queryBox;
    private SearchFactoryIntegrator searchFactory;
    protected HSQuery query;
    protected UUID lazyQueryId;
    protected int docIndex;

    public void init(Cache cache, HSQuery query, UUID lazyQueryId, int docIndex) {
        this.cache = cache;
        this.query = query;
        this.lazyQueryId = lazyQueryId;
        this.docIndex = docIndex;
    }

    public abstract QueryResponse perform();

    protected QueryBox getQueryBox() {
        if (this.queryBox == null) {
            ComponentRegistry cr = this.cache.getAdvancedCache().getComponentRegistry();
            this.queryBox = (QueryBox)cr.getLocalComponent(QueryBox.class);
        }
        return this.queryBox;
    }

    protected SearchFactoryIntegrator getSearchFactory() {
        if (this.searchFactory == null) {
            ComponentRegistry cr = this.cache.getAdvancedCache().getComponentRegistry();
            this.searchFactory = (SearchFactoryIntegrator)cr.getComponent(SearchFactoryIntegrator.class);
        }
        return this.searchFactory;
    }
}

