/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.UUID;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.clustered.ClusteredQueryCommandType;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.ClusteredQueryCommandWorker;

public class ClusteredQueryCommand
extends BaseRpcCommand
implements ReplicableCommand {
    public static final byte COMMAND_ID = 101;
    private ClusteredQueryCommandType commandType;
    private HSQuery query;
    private Cache cache;
    private UUID lazyQueryId;
    private Integer docIndex = 0;

    private ClusteredQueryCommand(ClusteredQueryCommandType type, String cacheName) {
        super(cacheName);
        this.commandType = type;
    }

    public ClusteredQueryCommand(String cacheName) {
        super(cacheName);
    }

    public void injectComponents(Cache cache) {
        this.cache = cache;
    }

    public static ClusteredQueryCommand createLazyIterator(HSQuery query, Cache cache, UUID id) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.CREATE_LAZY_ITERATOR, cache.getName());
        clQuery.query = query;
        clQuery.lazyQueryId = id;
        return clQuery;
    }

    public static ClusteredQueryCommand getResultSize(HSQuery query, Cache cache) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.GET_RESULT_SIZE, cache.getName());
        clQuery.query = query;
        return clQuery;
    }

    public static ClusteredQueryCommand createEagerIterator(HSQuery query, Cache cache) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.CREATE_EAGER_ITERATOR, cache.getName());
        clQuery.query = query;
        return clQuery;
    }

    public static ClusteredQueryCommand destroyLazyQuery(Cache cache, UUID id) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.DESTROY_LAZY_ITERATOR, cache.getName());
        clQuery.lazyQueryId = id;
        return clQuery;
    }

    public static ClusteredQueryCommand retrieveKeyFromLazyQuery(Cache cache, UUID id, int docIndex) {
        ClusteredQueryCommand clQuery = new ClusteredQueryCommand(ClusteredQueryCommandType.GET_SOME_KEYS, cache.getName());
        clQuery.lazyQueryId = id;
        clQuery.docIndex = docIndex;
        return clQuery;
    }

    public void initialize(Cache localInstance) {
        this.setCache(localInstance);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Object perform(InvocationContext context) throws Throwable {
        return this.perform(this.cache);
    }

    public QueryResponse perform(Cache cache) {
        ClusteredQueryCommandWorker worker = this.commandType.getCommand(cache, this.query, this.lazyQueryId, this.docIndex);
        return worker.perform();
    }

    public byte getCommandId() {
        return 101;
    }

    public Object[] getParameters() {
        return new Object[]{this.commandType, this.query, this.lazyQueryId, this.docIndex};
    }

    public void setParameters(int commandId, Object[] args) {
        int i = 0;
        this.commandType = (ClusteredQueryCommandType)((Object)args[i++]);
        this.query = (HSQuery)args[i++];
        this.lazyQueryId = (UUID)args[i++];
        this.docIndex = (Integer)args[i++];
    }

    public String toString() {
        return "ClusteredQuery{ cache=" + this.getCacheName() + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusteredQueryCommand)) {
            return false;
        }
        ClusteredQueryCommand other = (ClusteredQueryCommand)((Object)obj);
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName)) {
            return false;
        }
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }
}

