/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.query.Transformable;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.logging.Log;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.LogFactory;

public class KeyTransformationHandler {
    private static final Log log = (Log)LogFactory.getLog(KeyTransformationHandler.class, Log.class);
    private final Map<Class<?>, Class<? extends Transformer>> transformerTypes = ConcurrentMapFactory.makeConcurrentMap();

    public Object stringToKey(String s, ClassLoader classLoader) {
        char type = s.charAt(0);
        switch (type) {
            case 'S': {
                return s.substring(2);
            }
            case 'I': {
                return Integer.parseInt(s.substring(2));
            }
            case 'Y': {
                return Byte.parseByte(s.substring(2));
            }
            case 'L': {
                return Long.parseLong(s.substring(2));
            }
            case 'X': {
                return Short.parseShort(s.substring(2));
            }
            case 'D': {
                return Double.parseDouble(s.substring(2));
            }
            case 'F': {
                return Float.valueOf(Float.parseFloat(s.substring(2)));
            }
            case 'B': {
                return Boolean.parseBoolean(s.substring(2));
            }
            case 'C': {
                return Character.valueOf(s.charAt(2));
            }
            case 'T': {
                int indexOfSecondDelimiter = s.indexOf(":", 2);
                String keyClassName = s.substring(2, indexOfSecondDelimiter);
                String keyAsString = s.substring(indexOfSecondDelimiter + 1);
                Transformer t = this.getCustomTransformer(keyClassName, classLoader);
                if (t == null) {
                    throw new CacheException("Cannot find an appropriate Transformer for key type " + keyClassName);
                }
                return t.fromString(keyAsString);
            }
        }
        throw new CacheException("Unknown type metadata " + type);
    }

    private Transformer getCustomTransformer(String keyClassName, ClassLoader classLoader) {
        Transformer t = null;
        Class keyClass = null;
        try {
            keyClass = Util.loadClassStrict((String)keyClassName, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            log.keyClassNotFound(keyClassName, e);
        }
        if (keyClass != null) {
            t = this.getTransformer(keyClass);
        }
        return t;
    }

    public String keyToString(Object key) {
        int prefix = 32;
        Transformer tf = null;
        if (this.isStringOrPrimitive(key)) {
            if (key instanceof String) {
                prefix = 83;
            } else if (key instanceof Integer) {
                prefix = 73;
            } else if (key instanceof Boolean) {
                prefix = 66;
            } else if (key instanceof Long) {
                prefix = 76;
            } else if (key instanceof Float) {
                prefix = 70;
            } else if (key instanceof Double) {
                prefix = 68;
            } else if (key instanceof Short) {
                prefix = 88;
            } else if (key instanceof Byte) {
                prefix = 89;
            } else if (key instanceof Character) {
                prefix = 67;
            }
            return (char)prefix + ":" + key;
        }
        tf = this.getTransformer(key.getClass());
        if (tf != null) {
            return "T:" + key.getClass().getName() + ":" + tf.toString(key);
        }
        throw new IllegalArgumentException("Indexing only works with entries keyed on Strings, primitives and classes that have the @Transformable annotation - you passed in a " + key.getClass().toString() + ". Alternatively, see org.infinispan.query.SearchManager#registerKeyTransformer");
    }

    private boolean isStringOrPrimitive(Object key) {
        return key instanceof String || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Double || key instanceof Boolean || key instanceof Short || key instanceof Byte || key instanceof Character;
    }

    private Transformer getTransformer(Class<?> keyClass) {
        Class<? extends Transformer> transformerClass = this.getTransformerClass(keyClass);
        if (transformerClass != null) {
            return this.instantiate(transformerClass);
        }
        return null;
    }

    private Class<? extends Transformer> getTransformerClass(Class<?> keyClass) {
        Class<? extends Transformer> transformerClass = this.transformerTypes.get(keyClass);
        if (transformerClass == null && (transformerClass = this.getTransformerClassFromAnnotation(keyClass)) != null) {
            this.registerTransformer(keyClass, transformerClass);
        }
        return transformerClass;
    }

    private Class<? extends Transformer> getTransformerClassFromAnnotation(Class<?> keyClass) {
        Transformable annotation = keyClass.getAnnotation(Transformable.class);
        if (annotation != null) {
            return annotation.transformer();
        }
        return null;
    }

    private Transformer instantiate(Class<?> transformerClass) {
        try {
            return (Transformer)transformerClass.newInstance();
        }
        catch (Exception e) {
            log.couldNotInstantiaterTransformerClass(transformerClass, e);
            return null;
        }
    }

    public void registerTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.transformerTypes.put(keyClass, transformerClass);
    }

    public static KeyTransformationHandler getInstance(AdvancedCache<?, ?> cache) {
        QueryInterceptor queryInterceptor = ComponentRegistryUtils.getComponent(cache, QueryInterceptor.class);
        return queryInterceptor.getKeyTransformationHandler();
    }
}

