/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;

public class CacheQueryImpl
implements CacheQuery {
    protected final AdvancedCache<?, ?> cache;
    protected final KeyTransformationHandler keyTransformationHandler;
    protected HSQuery hSearchQuery;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryIntegrator searchFactory, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, Class<?> ... classes) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.cache = cache;
        this.hSearchQuery = searchFactory.createHSQuery();
        this.hSearchQuery.luceneQuery(luceneQuery).targetedEntities(Arrays.asList(classes));
    }

    @Override
    public CacheQuery filter(Filter filter) {
        this.hSearchQuery.filter(filter);
        return this;
    }

    @Override
    public int getResultSize() {
        return this.hSearchQuery.queryResultSize();
    }

    @Override
    public CacheQuery sort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public CacheQuery disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
        return this;
    }

    @Override
    public CacheQuery firstResult(int firstResult) {
        this.hSearchQuery.firstResult(firstResult);
        return this;
    }

    @Override
    public CacheQuery maxResults(int maxResults) {
        this.hSearchQuery.maxResults(maxResults);
        return this;
    }

    @Override
    public QueryIterator iterator() throws SearchException {
        return this.iterator(1);
    }

    @Override
    public QueryIterator iterator(int fetchSize) throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        List<Object> keyList = this.fromEntityInfosToKeys(entityInfos);
        return new EagerIterator(keyList, this.cache, fetchSize);
    }

    @Override
    public QueryIterator lazyIterator() {
        return this.lazyIterator(1);
    }

    @Override
    public QueryIterator lazyIterator(int fetchSize) {
        return new LazyIterator(this.hSearchQuery, this.cache, this.keyTransformationHandler, fetchSize);
    }

    @Override
    public List<Object> list() throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        EntityLoader loader = this.getLoader();
        List<Object> list = loader.load(entityInfos.toArray(new EntityInfo[entityInfos.size()]));
        return list;
    }

    private EntityLoader getLoader() {
        return new EntityLoader((Cache<?, ?>)this.cache, this.keyTransformationHandler);
    }

    private List<Object> fromEntityInfosToKeys(List<EntityInfo> entityInfos) {
        ArrayList<Object> keyList = new ArrayList<Object>(entityInfos.size());
        for (EntityInfo ei : entityInfos) {
            Object cacheKey = this.keyTransformationHandler.stringToKey(ei.getId().toString(), this.cache.getClassLoader());
            keyList.add(cacheKey);
        }
        return keyList;
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    @Override
    public Explanation explain(int documentId) {
        return this.hSearchQuery.explain(documentId);
    }

    @Override
    public CacheQuery projection(String ... fields) {
        this.hSearchQuery.projection(fields);
        return this;
    }
}

