/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.AbstractIterator;

@NotThreadSafe
public class LazyIterator
extends AbstractIterator {
    private final DocumentExtractor extractor;
    private final KeyTransformationHandler keyTransformationHandler;

    public LazyIterator(HSQuery hSearchQuery, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchsize passed. Your fetchSize is less than 1");
        }
        this.keyTransformationHandler = keyTransformationHandler;
        this.extractor = hSearchQuery.queryDocumentExtractor();
        this.index = 0;
        this.max = hSearchQuery.queryResultSize() - 1;
        this.cache = cache;
        this.fetchSize = fetchSize;
        this.buffer = new Object[this.fetchSize];
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index < this.first || index > this.max) {
            throw new IndexOutOfBoundsException("The given index is incorrect. Please check and try again.");
        }
        this.index = this.first + index;
    }

    @Override
    public void close() {
        this.extractor.close();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no next");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index >= this.bufferIndex && this.index < this.bufferIndex + bufferSize) {
            int indexToReturn = this.index - this.bufferIndex;
            toReturn = this.buffer[indexToReturn];
        } else {
            try {
                String documentId = (String)((Object)this.extractor.extract(this.index).getId());
                toReturn = this.cache.get(this.keyTransformationHandler.stringToKey(documentId, this.cache.getClassLoader()));
                Arrays.fill(this.buffer, null);
                this.buffer[0] = toReturn;
                for (int i = 1; i < bufferSize; ++i) {
                    Object toBuffer;
                    String bufferDocumentId = (String)((Object)this.extractor.extract(this.index + i).getId());
                    this.buffer[i] = toBuffer = this.cache.get(this.keyTransformationHandler.stringToKey(bufferDocumentId, this.cache.getClassLoader()));
                }
                this.bufferIndex = this.index;
            }
            catch (IOException e) {
                throw new CacheException();
            }
        }
        ++this.index;
        return toReturn;
    }

    @Override
    public Object previous() {
        if (!this.hasPrevious()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no previous");
        }
        Object toReturn = null;
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index <= this.bufferIndex && this.index >= this.bufferIndex + bufferSize) {
            int indexToReturn = this.bufferIndex - this.index;
            toReturn = this.buffer[indexToReturn];
        }
        try {
            Arrays.fill(this.buffer, null);
            String documentId = (String)((Object)this.extractor.extract(this.index).getId());
            this.buffer[0] = toReturn = this.cache.get(this.keyTransformationHandler.stringToKey(documentId, this.cache.getClassLoader()));
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                String bufferDocumentId = (String)((Object)this.extractor.extract(this.index - i).getId());
                this.buffer[i] = toBuffer = this.cache.get(this.keyTransformationHandler.stringToKey(bufferDocumentId, this.cache.getClassLoader()));
            }
            this.bufferIndex = this.index;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        --this.index;
        return toReturn;
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries.");
        }
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    @Override
    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    @Override
    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }
}

