/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.NoSuchElementException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.impl.QueryResultLoader;

public abstract class AbstractIterator
implements ResultIterator {
    protected final Object[] buffer;
    protected int index = 0;
    protected int bufferIndex = -1;
    protected int max;
    protected final int fetchSize;
    private final QueryResultLoader resultLoader;

    protected AbstractIterator(QueryResultLoader resultLoader, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchSize passed. Your fetchSize is less than 1");
        }
        this.resultLoader = resultLoader;
        this.fetchSize = fetchSize;
        this.buffer = new Object[fetchSize];
    }

    @Override
    public boolean hasNext() {
        return this.index <= this.max;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries. There is no next");
        }
        if (this.mustInitializeBuffer()) {
            this.fillBuffer(this.index);
        }
        int indexToReturn = this.index - this.bufferIndex;
        ++this.index;
        return this.buffer[indexToReturn];
    }

    private boolean mustInitializeBuffer() {
        return this.bufferIndex == -1 || this.index < this.bufferIndex || this.index >= this.bufferIndex + this.buffer.length;
    }

    private void fillBuffer(int startIndex) {
        this.bufferIndex = startIndex;
        int resultsToLoad = Math.min(this.buffer.length, this.max + 1 - this.bufferIndex);
        for (int i = 0; i < resultsToLoad; ++i) {
            this.buffer[i] = this.loadResult(this.bufferIndex + i);
        }
    }

    private Object loadResult(int index) {
        EntityInfo entityInfo = this.loadEntityInfo(index);
        return this.resultLoader.load(entityInfo);
    }

    protected abstract EntityInfo loadEntityInfo(int var1);
}

