/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.CacheException;
import org.infinispan.query.impl.AbstractIterator;
import org.infinispan.query.impl.QueryResultLoader;

@NotThreadSafe
public class LazyIterator
extends AbstractIterator {
    private final DocumentExtractor extractor;

    public LazyIterator(HSQuery hSearchQuery, QueryResultLoader resultLoader, int fetchSize) {
        super(resultLoader, fetchSize);
        this.extractor = hSearchQuery.queryDocumentExtractor();
        this.max = hSearchQuery.queryResultSize() - 1;
    }

    @Override
    public void close() {
        this.extractor.close();
    }

    @Override
    protected EntityInfo loadEntityInfo(int index) {
        try {
            return this.extractor.extract(index);
        }
        catch (IOException e) {
            throw new CacheException("Cannot load result at index " + index, (Throwable)e);
        }
    }
}

