/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerServiceProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryServiceProvider;
import org.infinispan.query.indexmanager.IndexUpdateCommand;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.LogFactory;

public class InfinispanCommandsBackend
implements BackendQueueProcessor {
    private static final Log log = (Log)LogFactory.getLog(InfinispanCommandsBackend.class, Log.class);
    private EmbeddedCacheManager cacheManager;
    private WorkerBuildContext context;
    private String indexName;
    private DistributionManager distributionManager;
    private RpcManager rpcManager;
    private String cacheName;
    private DirectoryBasedIndexManager indexManager;
    private HashSet<Class> knownTypes = new HashSet(10);

    public void initialize(Properties props, WorkerBuildContext context, DirectoryBasedIndexManager indexManager) {
        this.context = context;
        this.indexManager = indexManager;
        this.cacheManager = (EmbeddedCacheManager)context.requestService(CacheManagerServiceProvider.class);
        ComponentRegistry componentsRegistry = (ComponentRegistry)context.requestService(ComponentRegistryServiceProvider.class);
        this.indexName = indexManager.getIndexName();
        this.rpcManager = (RpcManager)componentsRegistry.getComponent(RpcManager.class);
        this.cacheName = componentsRegistry.getCacheName();
        this.distributionManager = (DistributionManager)componentsRegistry.getComponent(DistributionManager.class);
        log.commandsBackendInitialized(this.indexName);
    }

    public void close() {
        this.context.releaseService(CacheManagerServiceProvider.class);
        this.context.releaseService(ComponentRegistryServiceProvider.class);
        this.context = null;
        this.cacheManager = null;
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        IndexUpdateCommand command = new IndexUpdateCommand(this.cacheName);
        byte[] serializedModel = this.indexManager.getSerializer().toSerializedModel(workList);
        command.setSerializedWorkList(serializedModel);
        command.setKnownIndexedTypes(this.extractTypesUnique(workList));
        command.setIndexName(this.indexName);
        this.sendCommand(command, workList);
    }

    private Set<Class> extractTypesUnique(List<LuceneWork> workList) {
        for (LuceneWork work : workList) {
            Class entityClass = work.getEntityClass();
            if (entityClass == null) continue;
            this.knownTypes.add(work.getEntityClass());
        }
        return this.knownTypes;
    }

    private void sendCommand(ReplicableCommand command, List<LuceneWork> workList) {
        Address primaryNodeAddress = this.getPrimaryNodeAddress();
        Set<Address> recipients = Collections.singleton(primaryNodeAddress);
        this.rpcManager.invokeRemotely(recipients, command, true, false);
        log.workListRemotedTo(workList, primaryNodeAddress);
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.applyWork(Collections.singletonList(singleOperation), monitor);
    }

    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not Implementable: nonsense on a distributed index.");
    }

    public void indexMappingChanged() {
    }

    public boolean isMasterLocal() {
        Transport transport = this.cacheManager.getTransport();
        if (transport == null) {
            return true;
        }
        Address primaryLocation = this.getPrimaryNodeAddress();
        Address localAddress = transport.getAddress();
        return localAddress.equals(primaryLocation);
    }

    private Address getPrimaryNodeAddress() {
        Transport transport = this.cacheManager.getTransport();
        if (transport == null) {
            return null;
        }
        if (this.distributionManager == null) {
            List members = transport.getMembers();
            int elementIndex = Math.abs(this.indexName.hashCode()) % members.size();
            return (Address)members.get(elementIndex);
        }
        return this.distributionManager.getPrimaryLocation((Object)this.indexName);
    }
}

