/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.CompositeCondition;
import org.infinispan.query.dsl.impl.Visitable;

abstract class BaseCondition
implements FilterConditionContext,
Visitable {
    protected CompositeCondition parent = null;
    protected QueryBuilder queryBuilder;

    protected BaseCondition() {
    }

    @Override
    public QueryBuilder toBuilder() {
        if (this.queryBuilder == null) {
            throw new IllegalArgumentException("This sub-query does not belong to a parent query builder yet");
        }
        return this.queryBuilder;
    }

    void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public BaseCondition getRoot() {
        BaseCondition p = this;
        while (p.getParent() != null) {
            p = p.getParent();
        }
        return p;
    }

    public CompositeCondition getParent() {
        return this.parent;
    }

    public void setParent(CompositeCondition parent) {
        this.parent = parent;
    }

    @Override
    public FilterConditionBeginContext and() {
        AttributeCondition rightCondition = new AttributeCondition();
        this.combine(true, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext and(FilterConditionContext rightCondition) {
        this.combine(true, rightCondition);
        return this;
    }

    @Override
    public FilterConditionBeginContext or() {
        AttributeCondition rightCondition = new AttributeCondition();
        this.combine(false, rightCondition);
        return rightCondition;
    }

    @Override
    public FilterConditionContext or(FilterConditionContext rightCondition) {
        this.combine(false, rightCondition);
        return this;
    }

    private void combine(boolean isConjunction, FilterConditionContext fcc) {
        BaseCondition rightCondition = ((BaseCondition)fcc).getRoot();
        if (isConjunction && this.parent != null && !this.parent.isConjunction()) {
            CompositeCondition p = new CompositeCondition(true, this, rightCondition);
            this.parent.replaceChild(this, p);
            this.parent = p;
            rightCondition.setParent(p);
        } else {
            BaseCondition root = this.getRoot();
            CompositeCondition p = new CompositeCondition(isConjunction, root, rightCondition);
            root.setParent(p);
            rightCondition.setParent(p);
        }
        rightCondition.setQueryBuilder(this.queryBuilder);
    }
}

