/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.Visitor;

class CompositeCondition
extends BaseCondition {
    private final boolean isConjunction;
    private BaseCondition leftCondition;
    private BaseCondition rightCondition;

    public CompositeCondition(boolean isConjunction, BaseCondition leftCondition, BaseCondition rightCondition) {
        this.isConjunction = isConjunction;
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }

    public boolean isConjunction() {
        return this.isConjunction;
    }

    public BaseCondition getLeftCondition() {
        return this.leftCondition;
    }

    public BaseCondition getRightCondition() {
        return this.rightCondition;
    }

    public void replaceChild(BaseCondition oldChild, BaseCondition newChild) {
        if (this.leftCondition == oldChild) {
            this.leftCondition = newChild;
        } else if (this.rightCondition == oldChild) {
            this.rightCondition = newChild;
        } else {
            throw new IllegalStateException("Old child condition not found in parent");
        }
        newChild.setParent(this);
    }

    @Override
    void setQueryBuilder(QueryBuilder queryBuilder) {
        super.setQueryBuilder(queryBuilder);
        if (this.leftCondition != null) {
            this.leftCondition.setQueryBuilder(queryBuilder);
        }
        if (this.rightCondition != null) {
            this.rightCondition.setQueryBuilder(queryBuilder);
        }
    }

    public String toString() {
        return "(" + this.leftCondition + ") " + (this.isConjunction ? "AND" : "OR") + " (" + this.rightCondition + ")";
    }
}

