/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.jmx.StatisticsInfo;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.stat.Statistics;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CommandInitializer;
import org.infinispan.query.MassIndexer;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.clustered.QueryBox;
import org.infinispan.query.impl.massindex.MapReduceMassIndexer;
import org.infinispan.query.logging.Log;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private final Map<String, SearchFactoryIntegrator> searchFactoriesToShutdown = new TreeMap<String, SearchFactoryIntegrator>();
    private static final Object REMOVED_REGISTRY_COMPONENT = new Object();
    private MBeanServer mbeanServer;
    private ComponentMetadataRepo metadataRepo;
    private String jmxDomain;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        this.metadataRepo = gcr.getComponentMetadataRepo();
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        if (cfg.indexing().enabled()) {
            log.registeringQueryInterceptor();
            SearchFactoryIntegrator searchFactory = this.getSearchFactory((Properties)cfg.indexing().properties(), cr);
            this.createQueryInterceptorIfNeeded(cr, cfg, searchFactory);
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, SearchFactoryIntegrator searchFactory) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor == null) {
            queryInterceptor = this.buildQueryInterceptor(cfg, searchFactory);
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder().read(cfg);
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor((CommandInterceptor)queryInterceptor);
            if (!cfg.transaction().transactionMode().isTransactional()) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, NonTransactionalLockingInterceptor.class);
                }
                interceptorBuilder.after(NonTransactionalLockingInterceptor.class);
            } else if (cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, OptimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(OptimisticLockingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, PessimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(PessimisticLockingInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent((Object)queryInterceptor, QueryInterceptor.class);
                cr.registerComponent((Object)queryInterceptor, ((Object)((Object)queryInterceptor)).getClass().getName(), true);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    private QueryInterceptor buildQueryInterceptor(Configuration cfg, SearchFactoryIntegrator searchFactory) {
        if (cfg.indexing().indexLocalOnly()) {
            return new LocalQueryInterceptor(searchFactory);
        }
        return new QueryInterceptor(searchFactory);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean indexingEnabled = configuration.indexing().enabled();
        if (!indexingEnabled) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        Cache cache = (Cache)cr.getComponent(Cache.class);
        CommandInitializer initializer = (CommandInitializer)cr.getComponent(CommandInitializer.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cr.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
        initializer.setCache(cache, cacheManager);
        QueryBox queryBox = new QueryBox();
        queryBox.setCache(cache.getAdvancedCache());
        cr.registerComponent((Object)queryBox, QueryBox.class);
        this.registerQueryMBeans(cache.getAdvancedCache(), cr, cacheName);
    }

    private void registerQueryMBeans(AdvancedCache cache, ComponentRegistry cr, String cacheName) {
        Configuration cfg = cache.getCacheConfiguration();
        SearchFactoryIntegrator sf = this.getSearchFactory((Properties)cfg.indexing().properties(), cr);
        GlobalConfiguration globalCfg = cr.getGlobalComponentRegistry().getGlobalConfiguration();
        this.mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
        String queryGroupName = this.getQueryGroupName(cacheName);
        this.jmxDomain = JmxUtil.buildJmxDomain((GlobalConfiguration)globalCfg, (MBeanServer)this.mbeanServer, (String)queryGroupName);
        Statistics stats = sf.getStatistics();
        stats.setStatisticsEnabled(cfg.jmxStatistics().enabled());
        try {
            ObjectName statsObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=Statistics");
            JmxUtil.registerMBean((Object)new StatisticsInfo(stats), (ObjectName)statsObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register query module statistics mbean", (Throwable)e);
        }
        ManageableComponentMetadata metadata = this.metadataRepo.findComponentMetadata(MassIndexer.class).toManageableComponentMetadata();
        try {
            MapReduceMassIndexer maxIndexer = new MapReduceMassIndexer(cache, sf);
            ResourceDMBean mbean = new ResourceDMBean((Object)maxIndexer, metadata);
            ObjectName massIndexerObjName = new ObjectName(this.jmxDomain + ":" + queryGroupName + ",component=" + metadata.getJmxObjectName());
            JmxUtil.registerMBean((Object)mbean, (ObjectName)massIndexerObjName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create ", (Throwable)e);
        }
    }

    private String getQueryGroupName(String cacheName) {
        return "type=Query,name=" + ObjectName.quote(cacheName);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return interceptorChain.containsInterceptorType(QueryInterceptor.class, true);
    }

    private SearchFactoryIntegrator getSearchFactory(Properties indexingProperties, ComponentRegistry cr) {
        Object component = cr.getComponent(SearchFactoryIntegrator.class);
        SearchFactoryIntegrator searchFactory = null;
        if (component instanceof SearchFactoryIntegrator) {
            searchFactory = (SearchFactoryIntegrator)component;
        }
        if (searchFactory == null) {
            GlobalComponentRegistry globalComponentRegistry = cr.getGlobalComponentRegistry();
            EmbeddedCacheManager uninitializedCacheManager = (EmbeddedCacheManager)globalComponentRegistry.getComponent(EmbeddedCacheManager.class);
            SearchableCacheConfiguration config = new SearchableCacheConfiguration(new Class[0], indexingProperties, uninitializedCacheManager, cr);
            searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)config).buildSearchFactory();
            cr.registerComponent((Object)searchFactory, SearchFactoryIntegrator.class);
        }
        return searchFactory;
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        Object searchFactoryIntegrator = cr.getComponent(SearchFactoryIntegrator.class);
        if (searchFactoryIntegrator != null && searchFactoryIntegrator != REMOVED_REGISTRY_COMPONENT) {
            this.searchFactoriesToShutdown.put(cacheName, (SearchFactoryIntegrator)searchFactoryIntegrator);
            cr.registerComponent(REMOVED_REGISTRY_COMPONENT, SearchFactoryIntegrator.class);
        }
        if (this.mbeanServer != null) {
            String queryMBeanFilter = this.jmxDomain + ":" + this.getQueryGroupName(cacheName) + ",*";
            JmxUtil.unregisterMBeans((String)queryMBeanFilter, (MBeanServer)this.mbeanServer);
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        SearchFactoryIntegrator searchFactoryIntegrator = this.searchFactoriesToShutdown.remove(cacheName);
        if (searchFactoryIntegrator != null) {
            searchFactoryIntegrator.close();
        }
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        this.removeQueryInterceptorFromConfiguration(cfg);
    }

    private void removeQueryInterceptorFromConfiguration(Configuration cfg) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        CustomInterceptorsConfigurationBuilder customInterceptorsBuilder = builder.customInterceptors();
        for (InterceptorConfiguration interceptorConfig : cfg.customInterceptors().interceptors()) {
            if (interceptorConfig.interceptor() instanceof QueryInterceptor) continue;
            customInterceptorsBuilder.addInterceptor().read(interceptorConfig);
        }
        cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
    }
}

