/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.Serializable;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.impl.SimpleInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.massindex.DefaultMassIndexerProgressMonitor;

public final class IndexingMapper
implements Mapper<Object, Object, Object, LuceneWork> {
    private AdvancedCache cache;
    private SearchIntegrator searchFactory;
    private QueryInterceptor queryInterceptor;
    private KeyTransformationHandler keyTransformationHandler;
    private DefaultMassIndexerProgressMonitor progressMonitor;
    private DefaultBatchBackend defaultBatchBackend;

    public void initialize(Cache inputCache) {
        this.cache = inputCache.getAdvancedCache();
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(this.cache);
        this.searchFactory = this.queryInterceptor.getSearchFactory();
        this.keyTransformationHandler = this.queryInterceptor.getKeyTransformationHandler();
        this.progressMonitor = new DefaultMassIndexerProgressMonitor(inputCache.getAdvancedCache().getComponentRegistry().getTimeService());
        this.defaultBatchBackend = new DefaultBatchBackend(this.searchFactory, (MassIndexerProgressMonitor)this.progressMonitor);
    }

    public void map(Object key, Object value, Collector<Object, LuceneWork> collector) {
        if (this.queryInterceptor.updateKnownTypesIfNeeded(value)) {
            this.updateIndex(key, value, collector);
        }
    }

    private void updateIndex(Object key, Object value, Collector<Object, LuceneWork> collector) {
        Class<?> clazz = value.getClass();
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding(clazz);
        if (entityIndexBinding == null) {
            return;
        }
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        String idInString = this.keyTransformationHandler.keyToString(key);
        UpdateLuceneWork updateTask = docBuilder.createUpdateWork(clazz, value, (Serializable)((Object)idInString), idInString, (InstanceInitializer)SimpleInitializer.INSTANCE, (ConversionContext)conversionContext);
        try {
            this.defaultBatchBackend.enqueueAsyncWork((LuceneWork)updateTask);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void flush() {
        this.defaultBatchBackend.flush(this.searchFactory.getIndexedTypes());
    }
}

