/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.logging.Log;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class QueryCache {
    private static final Log log = (Log)LogFactory.getLog(QueryCache.class, Log.class);
    public static final String QUERY_CACHE_NAME = "___query_cache";
    private static final int MAX_ENTRIES = 200;
    private static final int ENTRY_LIFESPAN = 300;
    private EmbeddedCacheManager cacheManager;
    private volatile Cache<KeyValuePair<String, Class>, Object> lazyCache;

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public <T> T get(KeyValuePair<String, Class> queryKey) {
        Object cachedResult = this.getCache().get(queryKey);
        if (cachedResult != null) {
            log.debugf("QueryCache hit: %s, %s", queryKey.getKey(), queryKey.getValue());
        }
        return (T)cachedResult;
    }

    public void put(KeyValuePair<String, Class> queryKey, Object queryParsingResult) {
        this.getCache().put(queryKey, queryParsingResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<KeyValuePair<String, Class>, Object> getCache() {
        Cache<KeyValuePair<String, Class>, Object> cache = this.lazyCache;
        if (cache != null) {
            return cache;
        }
        QueryCache queryCache = this;
        synchronized (queryCache) {
            if (this.lazyCache == null) {
                if (this.cacheManager.getCacheConfiguration(QUERY_CACHE_NAME) == null) {
                    this.cacheManager.defineConfiguration(QUERY_CACHE_NAME, this.getDefaultQueryCacheConfig().build());
                }
                this.lazyCache = this.cacheManager.getCache(QUERY_CACHE_NAME);
            }
            return this.lazyCache;
        }
    }

    private ConfigurationBuilder getDefaultQueryCacheConfig() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).expiration().maxIdle(300L, TimeUnit.SECONDS).eviction().maxEntries(200L).strategy(EvictionStrategy.LIRS);
        return cfgBuilder;
    }
}

