/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public class LuceneBytesRefExternalizer
extends AbstractExternalizer<BytesRef> {
    public Set<Class<? extends BytesRef>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{BytesRef.class});
    }

    public void writeObject(ObjectOutput output, BytesRef object) throws IOException {
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.length);
        output.write(object.bytes, object.offset, object.length);
    }

    public BytesRef readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int length = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        byte[] bytes = new byte[length];
        input.readFully(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }
}

