/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.Set;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.impl.batch.DefaultBatchBackend;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;

public class ExtendedBatchBackend
implements BatchBackend {
    private final DefaultBatchBackend defaultBatchBackend;
    private final SearchIntegrator integrator;
    private final MassIndexerProgressMonitor progressMonitor;

    public ExtendedBatchBackend(SearchIntegrator integrator, MassIndexerProgressMonitor progressMonitor) {
        this.integrator = integrator;
        this.progressMonitor = progressMonitor;
        this.defaultBatchBackend = new DefaultBatchBackend(integrator, progressMonitor);
    }

    public void purge(Set<Class<?>> entityTypes) {
        for (Class<?> type : entityTypes) {
            IndexManager[] indexManagers;
            EntityIndexBinding indexBindingForEntity = this.integrator.getIndexBinding(type);
            if (indexBindingForEntity == null) continue;
            for (IndexManager im : indexManagers = indexBindingForEntity.getIndexManagers()) {
                im.performStreamOperation((LuceneWork)new PurgeAllLuceneWork(type), (IndexingMonitor)this.progressMonitor, false);
            }
        }
        this.flush(entityTypes);
    }

    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.defaultBatchBackend.enqueueAsyncWork(work);
    }

    public void doWorkInSync(LuceneWork work) {
        this.defaultBatchBackend.doWorkInSync(work);
    }

    public void flush(Set<Class<?>> indexedRootTypes) {
        this.defaultBatchBackend.flush(indexedRootTypes);
    }

    public void optimize(Set<Class<?>> targetedClasses) {
        this.defaultBatchBackend.optimize(targetedClasses);
    }
}

