/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.logging.Log;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class QueryCache {
    private static final Log log = (Log)LogFactory.getLog(QueryCache.class, Log.class);
    private final boolean trace = log.isTraceEnabled();
    public static final String QUERY_CACHE_NAME = "___query_cache";
    private static final long MAX_ENTRIES = 200L;
    private static final long ENTRY_LIFESPAN = 300L;
    private EmbeddedCacheManager cacheManager;
    private InternalCacheRegistry internalCacheRegistry;
    private volatile Cache<KeyValuePair<String, ?>, Object> lazyCache;

    @Inject
    public void init(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    public <T> T get(KeyValuePair<String, ?> queryKey) {
        Object cachedResult = this.getCache().get(queryKey);
        if (this.trace && cachedResult != null) {
            log.tracef("QueryCache hit: %s, %s", queryKey.getKey(), queryKey.getValue());
        }
        return (T)cachedResult;
    }

    public void put(KeyValuePair<String, ?> queryKey, Object queryParsingResult) {
        this.getCache().put(queryKey, queryParsingResult);
    }

    public void clear() {
        this.getCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<KeyValuePair<String, ?>, Object> getCache() {
        Cache<KeyValuePair<String, ?>, Object> cache = this.lazyCache;
        if (cache != null) {
            return cache;
        }
        QueryCache queryCache = this;
        synchronized (queryCache) {
            if (this.lazyCache == null) {
                this.internalCacheRegistry.registerInternalCache(QUERY_CACHE_NAME, this.getDefaultQueryCacheConfig().build(), EnumSet.noneOf(InternalCacheRegistry.Flag.class));
                this.lazyCache = this.cacheManager.getCache(QUERY_CACHE_NAME);
            }
            return this.lazyCache;
        }
    }

    private ConfigurationBuilder getDefaultQueryCacheConfig() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).expiration().maxIdle(300L, TimeUnit.SECONDS).eviction().type(EvictionType.COUNT).size(200L).strategy(EvictionStrategy.LIRS);
        return cfgBuilder;
    }
}

