/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.BaseEmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;

final class EmbeddedQuery
extends BaseEmbeddedQuery {
    private final QueryEngine queryEngine;
    private JPAFilterAndConverter<?, ?> filter;

    EmbeddedQuery(QueryEngine queryEngine, QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, cache, queryString, namedParameters, projection, startOffset, maxResults);
        this.queryEngine = queryEngine;
    }

    @Override
    public void resetQuery() {
        super.resetQuery();
        this.filter = null;
    }

    private JPAFilterAndConverter createFilter() {
        if (this.filter == null) {
            this.filter = this.queryEngine.createAndWireFilter(this.queryString, this.namedParameters);
            this.filter.getObjectFilter();
        }
        return this.filter;
    }

    @Override
    protected Comparator<Comparable[]> getComparator() {
        return this.createFilter().getObjectFilter().getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getIterator() {
        CacheStream stream = (CacheStream)CacheFilters.filterAndConvert((Stream)this.cache.cacheEntrySet().stream(), (KeyValueFilterConverter)this.createFilter());
        return Closeables.iterator((Stream)stream.map(CacheEntry::getValue));
    }

    @Override
    public String toString() {
        return "EmbeddedQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

