/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.SecurityActions;

public class IndexWorker
implements DistributedCallable<Object, Object, Void> {
    protected final Class<?> entity;
    private final boolean flush;
    private final boolean clean;
    private final boolean primaryOwner;
    protected Cache<Object, Object> cache;
    protected IndexUpdater indexUpdater;
    private Set<Object> everywhereKeys;
    private Set<Object> keys = new HashSet<Object>();
    private ClusteringDependentLogic clusteringDependentLogic;
    private Encoder valueEncoder;

    public IndexWorker(Class<?> entity, boolean flush, boolean clean, boolean primaryOwner, Set<Object> everywhereKeys) {
        this.entity = entity;
        this.flush = flush;
        this.clean = clean;
        this.primaryOwner = primaryOwner;
        this.everywhereKeys = everywhereKeys;
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        this.cache = cache;
        this.indexUpdater = new IndexUpdater(cache);
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache());
        this.clusteringDependentLogic = (ClusteringDependentLogic)componentRegistry.getComponent(ClusteringDependentLogic.class);
        if (this.everywhereKeys != null && this.everywhereKeys.size() > 0) {
            this.keys.addAll(this.everywhereKeys);
        }
        if (inputKeys != null && inputKeys.size() > 0) {
            this.keys.addAll(inputKeys);
        }
        this.valueEncoder = cache.getAdvancedCache().getValueEncoder();
    }

    protected void preIndex() {
        if (this.clean) {
            this.indexUpdater.purge(this.entity);
        }
    }

    protected void postIndex() {
        this.indexUpdater.waitForAsyncCompletion();
        if (this.flush) {
            this.indexUpdater.flush(this.entity);
        }
    }

    private KeyValueFilter getFilter() {
        return this.primaryOwner ? new PrimaryOwnersKeyValueFilter() : AcceptAllKeyValueFilter.getInstance();
    }

    private Object extractValue(Object wrappedValue) {
        return this.valueEncoder.fromStorage(wrappedValue);
    }

    public Void call() throws Exception {
        Cache<Object, Object> unwrappedCache = SecurityActions.getUnwrappedCache(this.cache);
        if (this.keys == null || this.keys.size() == 0) {
            this.preIndex();
            KeyValueFilter filter = this.getFilter();
            Throwable throwable = null;
            try (CacheStream stream = unwrappedCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).cacheEntrySet().stream();){
                Iterator iterator = stream.filter(CacheFilters.predicate((KeyValueFilter)filter)).iterator();
                while (iterator.hasNext()) {
                    CacheEntry next = (CacheEntry)iterator.next();
                    Object value = this.extractValue(next.getValue());
                    if (value == null || !value.getClass().equals(this.entity)) continue;
                    this.indexUpdater.updateIndex(next.getKey(), value);
                }
            }
            catch (Throwable iterator) {
                Throwable throwable2 = iterator;
                throw iterator;
            }
            this.postIndex();
        } else {
            HashSet classSet = new HashSet();
            for (Object object : this.keys) {
                Object value = this.extractValue(unwrappedCache.get(object));
                if (value == null) continue;
                this.indexUpdater.updateIndex(object, value);
                classSet.add(value.getClass());
            }
            for (Class clazz : classSet) {
                this.indexUpdater.flush(clazz);
            }
        }
        return null;
    }

    private class PrimaryOwnersKeyValueFilter
    implements KeyValueFilter {
        private PrimaryOwnersKeyValueFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return IndexWorker.this.clusteringDependentLogic.getCacheTopology().getDistribution(key).isPrimary();
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<IndexWorker> {
        public Set<Class<? extends IndexWorker>> getTypeClasses() {
            return Collections.singleton(IndexWorker.class);
        }

        public void writeObject(ObjectOutput output, IndexWorker worker) throws IOException {
            output.writeObject(worker.entity);
            output.writeBoolean(worker.flush);
            output.writeBoolean(worker.clean);
            output.writeBoolean(worker.primaryOwner);
            output.writeObject(worker.everywhereKeys);
        }

        public IndexWorker readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IndexWorker((Class)input.readObject(), input.readBoolean(), input.readBoolean(), input.readBoolean(), (Set)input.readObject());
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_WORKER;
        }
    }
}

