/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.query.affinity.AffinityIndexManager;
import org.infinispan.query.affinity.AffinityUpdateCommand;
import org.infinispan.query.affinity.ShardAddress;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.LuceneWorkConverter;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.LogFactory;

class LuceneWorkDispatcher {
    private static final Log log = (Log)LogFactory.getLog(AffinityIndexManager.class, Log.class);
    private final AffinityIndexManager indexManager;
    private final RpcManager rpcManager;

    LuceneWorkDispatcher(AffinityIndexManager affinityIndexManager, RpcManager rpcManager) {
        this.indexManager = affinityIndexManager;
        this.rpcManager = rpcManager;
    }

    void dispatch(List<LuceneWork> works, ShardAddress destination, boolean originLocal) {
        if (destination.getAddress().equals(this.indexManager.getLocalShardAddress().getAddress())) {
            this.performLocally(works, destination.getShard(), this.indexManager.getKeyTransformationHandler(), this.indexManager.getSearchIntegrator(), originLocal);
        } else {
            this.sendRemotely(works, destination, originLocal);
        }
    }

    private void performLocally(Collection<LuceneWork> luceneWorks, String shard, KeyTransformationHandler handler, SearchIntegrator integrator, boolean originLocal) {
        List<LuceneWork> workToApply = LuceneWorkConverter.transformKeysToString(luceneWorks, handler);
        for (LuceneWork luceneWork : workToApply) {
            AffinityIndexManager im = (AffinityIndexManager)this.getIndexManagerByName(luceneWork, shard, integrator);
            if (log.isDebugEnabled()) {
                log.debugf("Performing local redirected for work %s on index %s", workToApply, im.getIndexName());
            }
            im.performOperations(Collections.singletonList(luceneWork), null, originLocal, false);
        }
    }

    private IndexManager getIndexManagerByName(LuceneWork luceneWork, String name, SearchIntegrator searchFactory) {
        IndexedTypeIdentifier entityClass = luceneWork.getEntityType();
        IndexManager[] indexManagersForAllShards = searchFactory.getIndexBinding(entityClass).getSelectionStrategy().getIndexManagersForAllShards();
        return (IndexManager)Arrays.stream(indexManagersForAllShards).filter(im -> im.getIndexName().equals(name)).iterator().next();
    }

    private boolean shouldSendSync(boolean originLocal) {
        return !this.indexManager.isAsync() && originLocal;
    }

    private void sendRemotely(List<LuceneWork> works, ShardAddress destination, boolean originLocal) {
        String cacheName = this.indexManager.getCacheName();
        AffinityUpdateCommand indexUpdateCommand = new AffinityUpdateCommand(ByteString.fromString((String)cacheName));
        byte[] serializedModel = this.indexManager.getSerializer().toSerializedModel(works);
        indexUpdateCommand.setSerializedWorkList(serializedModel);
        indexUpdateCommand.setIndexName(destination.getShard());
        List<Address> dest = Collections.singletonList(destination.getAddress());
        if (this.shouldSendSync(originLocal)) {
            log.debugf("Sending sync works %s to %s", works, dest);
            Map response = this.rpcManager.invokeRemotely(dest, (ReplicableCommand)indexUpdateCommand, this.rpcManager.getDefaultRpcOptions(true));
            log.debugf("Response %s obtained for command %s", response, works);
        } else {
            log.debugf("Sending async works %s to %s", works, dest);
            CompletableFuture result = this.rpcManager.invokeRemotelyAsync(dest, (ReplicableCommand)indexUpdateCommand, this.rpcManager.getDefaultRpcOptions(this.shouldSendSync(originLocal)));
            result.whenComplete((responses, error) -> {
                if (error != null) {
                    log.error("Error forwarding index job", (Throwable)error);
                }
                log.debugf("Async work %s applied successfully with response %s", works, responses);
            });
        }
    }
}

