/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.beans.IntrospectionException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.BooleanBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.elasticsearch.bridge.builtin.impl.ElasticsearchDateBridge;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionPropertyHelper;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryMaker;
import org.infinispan.query.logging.Log;
import org.jboss.logging.Logger;

public final class HibernateSearchPropertyHelper
extends ReflectionPropertyHelper {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)HibernateSearchPropertyHelper.class.getName());
    private final SearchIntegrator searchFactory;

    public HibernateSearchPropertyHelper(SearchIntegrator searchFactory, EntityNameResolver entityNameResolver) {
        super(entityNameResolver);
        this.searchFactory = searchFactory;
    }

    public List<?> mapPropertyNamePathToFieldIdPath(Class<?> entityType, String[] propertyPath) {
        ResolvedProperty resolvedProperty;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (resolvedProperty = this.resolveProperty(indexBinding, propertyPath)) != null) {
            ArrayList<String> translatedPropertyPath = new ArrayList<String>(propertyPath.length);
            for (EmbeddedTypeMetadata embeddedTypeMetadata : resolvedProperty.embeddedTypeMetadataList) {
                translatedPropertyPath.add(embeddedTypeMetadata.getEmbeddedPropertyName());
            }
            if (resolvedProperty.propertyMetadata != null) {
                translatedPropertyPath.add(resolvedProperty.propertyMetadata.getPropertyAccessorName());
            }
            return translatedPropertyPath;
        }
        return super.mapPropertyNamePathToFieldIdPath(entityType, propertyPath);
    }

    public Object convertToPropertyType(Class<?> entityType, String[] propertyPath, String value) {
        DocumentFieldMetadata fieldMetadata;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (fieldMetadata = this.getDocumentFieldMetadata(indexBinding, propertyPath)) != null) {
            FieldBridge bridge = fieldMetadata.getFieldBridge();
            return this.convertToPropertyType(value, bridge);
        }
        return super.convertToPropertyType(entityType, propertyPath, value);
    }

    private Object convertToPropertyType(String value, FieldBridge bridge) {
        try {
            if (bridge instanceof NullEncodingTwoWayFieldBridge) {
                return this.convertToPropertyType(value, (FieldBridge)((NullEncodingTwoWayFieldBridge)bridge).unwrap(FieldBridge.class));
            }
            if (bridge instanceof TwoWayString2FieldBridgeAdaptor) {
                TwoWayStringBridge unwrapped = (TwoWayStringBridge)((TwoWayString2FieldBridgeAdaptor)bridge).unwrap(TwoWayStringBridge.class);
                if (unwrapped instanceof BooleanBridge && !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                    throw log.getInvalidBooleanLiteralException(value);
                }
                return unwrapped.stringToObject(value);
            }
            if (bridge instanceof TwoWayStringBridge) {
                return ((TwoWayStringBridge)bridge).stringToObject(value);
            }
            if (bridge instanceof NumericFieldBridge) {
                switch ((NumericFieldBridge)bridge) {
                    case INT_FIELD_BRIDGE: {
                        return Integer.valueOf(value);
                    }
                    case LONG_FIELD_BRIDGE: {
                        return Long.valueOf(value);
                    }
                    case FLOAT_FIELD_BRIDGE: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE_FIELD_BRIDGE: {
                        return Double.valueOf(value);
                    }
                }
                return value;
            }
            if (bridge instanceof StringEncodingCalendarBridge || bridge instanceof NumericEncodingCalendarBridge) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateTools.stringToDate((String)value));
                return calendar;
            }
            if (bridge instanceof StringEncodingDateBridge || bridge instanceof NumericEncodingDateBridge || bridge instanceof ElasticsearchDateBridge) {
                return DateTools.stringToDate((String)value);
            }
            return value;
        }
        catch (ParseException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public Class<?> getPrimitivePropertyType(Class<?> entityType, String[] propertyPath) {
        ResolvedProperty resolvedProperty;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (resolvedProperty = this.resolveProperty(indexBinding, propertyPath)) != null) {
            TypeMetadata typeMetadata = resolvedProperty.embeddedTypeMetadataList.isEmpty() ? resolvedProperty.rootTypeMetadata : (TypeMetadata)resolvedProperty.embeddedTypeMetadataList.get(resolvedProperty.embeddedTypeMetadataList.size() - 1);
            if (resolvedProperty.propertyMetadata != null) {
                ReflectionHelper.PropertyAccessor accessor = this.getPropertyAccessor(typeMetadata.getType().getPojoType(), resolvedProperty.propertyMetadata.getPropertyAccessorName());
                Class c = accessor.getPropertyType();
                if (c.isEnum()) {
                    return c;
                }
                return (Class)primitives.get(c);
            }
            return null;
        }
        return super.getPrimitivePropertyType(entityType, propertyPath);
    }

    public boolean isRepeatedProperty(Class<?> entityType, String[] propertyPath) {
        ResolvedProperty resolvedProperty;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (resolvedProperty = this.resolveProperty(indexBinding, propertyPath)) != null) {
            TypeMetadata typeMetadata = resolvedProperty.rootTypeMetadata;
            for (EmbeddedTypeMetadata embeddedTypeMetadata : resolvedProperty.embeddedTypeMetadataList) {
                ReflectionHelper.PropertyAccessor accessor = this.getPropertyAccessor(typeMetadata.getType().getPojoType(), embeddedTypeMetadata.getEmbeddedPropertyName());
                if (accessor.isMultiple()) {
                    return true;
                }
                typeMetadata = embeddedTypeMetadata;
            }
            if (resolvedProperty.propertyMetadata != null) {
                ReflectionHelper.PropertyAccessor accessor = this.getPropertyAccessor(typeMetadata.getType().getPojoType(), resolvedProperty.propertyMetadata.getPropertyAccessorName());
                return accessor.isMultiple();
            }
            return false;
        }
        return super.isRepeatedProperty(entityType, propertyPath);
    }

    private EntityIndexBinding getEntityIndexBinding(Class<?> entityType) {
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding == null) {
            throw log.getNoIndexedEntityException(entityType.getCanonicalName());
        }
        return indexBinding;
    }

    private ReflectionHelper.PropertyAccessor getPropertyAccessor(Class<?> type, String propertyName) {
        try {
            return ReflectionHelper.getAccessor(type, (String)propertyName);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public LuceneQueryMaker.FieldBridgeAndAnalyzerProvider<Class<?>> getDefaultFieldBridgeProvider() {
        return new LuceneQueryMaker.FieldBridgeAndAnalyzerProvider<Class<?>>(){

            @Override
            public FieldBridge getFieldBridge(Class<?> entityType, String[] propertyPath) {
                DocumentFieldMetadata fieldMetadata;
                EntityIndexBinding indexBinding = HibernateSearchPropertyHelper.this.getEntityIndexBinding(entityType);
                if (indexBinding != null && (fieldMetadata = HibernateSearchPropertyHelper.this.getDocumentFieldMetadata(indexBinding, propertyPath)) != null) {
                    return fieldMetadata.getFieldBridge();
                }
                return null;
            }

            @Override
            public Analyzer getAnalyzer(SearchIntegrator searchIntegrator, Class<?> entityType, String[] propertyPath) {
                AnalyzerReference analyzerReference;
                DocumentFieldMetadata fieldMetadata;
                EntityIndexBinding indexBinding = HibernateSearchPropertyHelper.this.getEntityIndexBinding(entityType);
                if (indexBinding != null && (fieldMetadata = HibernateSearchPropertyHelper.this.getDocumentFieldMetadata(indexBinding, propertyPath)) != null && (analyzerReference = fieldMetadata.getAnalyzerReference()).is(LuceneAnalyzerReference.class)) {
                    return ((LuceneAnalyzerReference)analyzerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer();
                }
                return null;
            }

            @Override
            public void overrideAnalyzers(IckleParsingResult<Class<?>> parsingResult, EntityContext entityContext) {
            }
        };
    }

    public boolean hasProperty(Class<?> entityType, String[] propertyPath) {
        ResolvedProperty resolvedProperty;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (resolvedProperty = this.resolveProperty(indexBinding, propertyPath)) != null) {
            return true;
        }
        return super.hasProperty(entityType, propertyPath);
    }

    public boolean hasEmbeddedProperty(Class<?> entityType, String[] propertyPath) {
        ResolvedProperty resolvedProperty;
        EntityIndexBinding indexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(entityType);
        if (indexBinding != null && (resolvedProperty = this.resolveProperty(indexBinding, propertyPath)) != null) {
            return resolvedProperty.propertyMetadata == null;
        }
        return super.hasEmbeddedProperty(entityType, propertyPath);
    }

    private DocumentFieldMetadata getDocumentFieldMetadata(EntityIndexBinding indexBinding, String[] propertyPath) {
        ResolvedProperty resolvedProperty = this.resolveProperty(indexBinding, propertyPath);
        if (resolvedProperty != null && resolvedProperty.documentFieldMetadata != null) {
            return resolvedProperty.documentFieldMetadata;
        }
        return null;
    }

    public IndexedFieldProvider<Class<?>> getIndexedFieldProvider() {
        return type -> {
            final EntityIndexBinding entityIndexBinding = (EntityIndexBinding)this.searchFactory.getIndexBindings().get(type);
            if (entityIndexBinding == null) {
                return IndexedFieldProvider.NO_INDEXING;
            }
            return new IndexedFieldProvider.FieldIndexingMetadata(){

                public boolean isIndexed(String[] propertyPath) {
                    DocumentFieldMetadata fieldMetadata = HibernateSearchPropertyHelper.this.getDocumentFieldMetadata(entityIndexBinding, propertyPath);
                    return fieldMetadata != null && fieldMetadata.getIndex().isIndexed();
                }

                public boolean isAnalyzed(String[] propertyPath) {
                    DocumentFieldMetadata fieldMetadata = HibernateSearchPropertyHelper.this.getDocumentFieldMetadata(entityIndexBinding, propertyPath);
                    return fieldMetadata != null && fieldMetadata.getIndex().isAnalyzed();
                }

                public boolean isStored(String[] propertyPath) {
                    DocumentFieldMetadata fieldMetadata = HibernateSearchPropertyHelper.this.getDocumentFieldMetadata(entityIndexBinding, propertyPath);
                    return fieldMetadata != null && fieldMetadata.getStore() != Store.NO;
                }
            };
        };
    }

    private ResolvedProperty resolveProperty(EntityIndexBinding entityIndexBinding, String[] propertyPath) {
        TypeMetadata rootTypeMetadata;
        if (propertyPath.length == 0) {
            return null;
        }
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        TypeMetadata typeMetadata = rootTypeMetadata = docBuilder.getTypeMetadata();
        ArrayList<EmbeddedTypeMetadata> embeddedTypeMetadataList = new ArrayList<EmbeddedTypeMetadata>(propertyPath.length - 1);
        for (int i = 0; i < propertyPath.length; ++i) {
            String propPath;
            DocumentFieldMetadata documentFieldMetadata;
            if (i == propertyPath.length - 1 && (documentFieldMetadata = typeMetadata.getDocumentFieldMetadataFor(propPath = StringHelper.join((String[])propertyPath))) != null) {
                for (PropertyMetadata pm : typeMetadata.getAllPropertyMetadata()) {
                    DocumentFieldMetadata fm = pm.getFieldMetadata(propPath);
                    if (fm == null) continue;
                    return new ResolvedProperty(rootTypeMetadata, embeddedTypeMetadataList, documentFieldMetadata, pm);
                }
                return null;
            }
            boolean found = false;
            for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
                if (!embeddedTypeMetadata.getEmbeddedPropertyName().equals(propertyPath[i])) continue;
                embeddedTypeMetadataList.add(embeddedTypeMetadata);
                if (i == propertyPath.length - 1) {
                    return new ResolvedProperty(rootTypeMetadata, embeddedTypeMetadataList, null, null);
                }
                typeMetadata = embeddedTypeMetadata;
                found = true;
                break;
            }
            if (!found) break;
        }
        return null;
    }

    private static final class ResolvedProperty {
        final TypeMetadata rootTypeMetadata;
        final List<EmbeddedTypeMetadata> embeddedTypeMetadataList;
        final PropertyMetadata propertyMetadata;
        final DocumentFieldMetadata documentFieldMetadata;

        ResolvedProperty(TypeMetadata rootTypeMetadata, List<EmbeddedTypeMetadata> embeddedTypeMetadataList, DocumentFieldMetadata documentFieldMetadata, PropertyMetadata propertyMetadata) {
            this.rootTypeMetadata = rootTypeMetadata;
            this.embeddedTypeMetadataList = embeddedTypeMetadataList;
            this.documentFieldMetadata = documentFieldMetadata;
            this.propertyMetadata = propertyMetadata;
        }
    }
}

