/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;
import org.infinispan.query.indexmanager.LuceneWorkConverter;
import org.infinispan.query.logging.Log;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IndexUpdateStreamCommand
extends AbstractUpdateCommand {
    private static final Log log = (Log)LogFactory.getLog(IndexUpdateStreamCommand.class, Log.class);
    public static final byte COMMAND_ID = 103;

    public IndexUpdateStreamCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName.toString());
        }
        IndexManager indexManager = this.searchFactory.getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        KeyTransformationHandler handler = this.queryInterceptor.getKeyTransformationHandler();
        LuceneWork workToApply = LuceneWorkConverter.transformKeysToString((LuceneWork)luceneWorks.iterator().next(), handler);
        indexManager.performStreamOperation(workToApply, null, true);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 103;
    }
}

