/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import org.apache.lucene.search.TopDocs;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.ClusteredQueryCommandWorker;
import org.infinispan.query.clustered.commandworkers.QueryExtractorUtil;

public class CQCreateEagerQuery
extends ClusteredQueryCommandWorker {
    @Override
    public QueryResponse perform() {
        HSQuery query = this.queryDefinition.getHsQuery();
        query.afterDeserialise(this.getSearchFactory());
        try (DocumentExtractor extractor = query.queryDocumentExtractor();){
            int resultSize = query.queryResultSize();
            NodeTopDocs eagerTopDocs = resultSize == 0 ? null : this.collectKeys(extractor, query);
            QueryResponse queryResponse = new QueryResponse(eagerTopDocs, this.getQueryBox().getMyId(), resultSize);
            queryResponse.setAddress(this.cache.getAdvancedCache().getRpcManager().getAddress());
            QueryResponse queryResponse2 = queryResponse;
            return queryResponse2;
        }
    }

    private NodeTopDocs collectKeys(DocumentExtractor extractor, HSQuery query) {
        TopDocs topDocs = extractor.getTopDocs();
        int topDocsLength = topDocs.scoreDocs.length;
        Object[] keys = null;
        Object[] projections = null;
        KeyTransformationHandler keyTransformationHandler = KeyTransformationHandler.getInstance(this.cache.getAdvancedCache());
        if (query.getProjectedFields() == null) {
            keys = new Object[topDocsLength];
            for (int i = 0; i < topDocsLength; ++i) {
                keys[i] = QueryExtractorUtil.extractKey(extractor, this.cache, keyTransformationHandler, i);
            }
        } else {
            projections = new Object[topDocsLength];
            for (int i = 0; i < topDocsLength; ++i) {
                projections[i] = QueryExtractorUtil.extractProjection(extractor, i);
            }
        }
        return new NodeTopDocs(topDocs, keys, projections);
    }
}

