/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.infinispan.AdvancedCache;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.LogFactory;

class DistributedIterator<E>
implements ResultIterator<E> {
    private static final Log log = (Log)LogFactory.getLog(DistributedIterator.class, Log.class);
    protected final AdvancedCache<?, ?> cache;
    private int currentIndex = -1;
    private final int fetchSize;
    private final int resultSize;
    private final int maxResults;
    private final int firstResult;
    private final NodeTopDocs[] partialResults;
    private final int[] partialPositionNext;
    private final TopDocs mergedResults;

    DistributedIterator(Sort sort, int fetchSize, int resultSize, int maxResults, int firstResult, Map<Address, NodeTopDocs> topDocsResponses, AdvancedCache<?, ?> cache) {
        this.fetchSize = fetchSize;
        this.resultSize = resultSize;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.cache = cache;
        int parallels = topDocsResponses.size();
        this.partialResults = new NodeTopDocs[parallels];
        TopFieldDocs[] partialTopDocs = sort != null ? new TopFieldDocs[parallels] : new TopDocs[parallels];
        this.partialPositionNext = new int[parallels];
        int i = 0;
        for (Map.Entry<Address, NodeTopDocs> entry : topDocsResponses.entrySet()) {
            this.partialResults[i] = entry.getValue();
            partialTopDocs[i] = this.partialResults[i].topDocs;
            ++i;
        }
        try {
            this.mergedResults = sort != null ? TopDocs.merge((Sort)sort, (int)firstResult, (int)maxResults, (TopFieldDocs[])partialTopDocs) : TopDocs.merge((int)firstResult, (int)maxResults, (TopDocs[])partialTopDocs);
        }
        catch (IOException e) {
            throw log.unexpectedIOException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        ScoreDoc scoreDoc = this.mergedResults.scoreDocs[this.currentIndex];
        int index = scoreDoc.shardIndex;
        if (this.partialPositionNext[index] == 0) {
            this.partialPositionNext[index] = this.findSpecificPosition(scoreDoc.doc, this.partialResults[index].topDocs);
        }
        int specificPosition = this.partialPositionNext[index];
        int n = index;
        this.partialPositionNext[n] = this.partialPositionNext[n] + 1;
        return this.fetchValue(specificPosition, this.partialResults[index]);
    }

    private int findSpecificPosition(int docId, TopDocs topDocs) {
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            if (topDocs.scoreDocs[i].doc != docId) continue;
            return i;
        }
        return 0;
    }

    protected E fetchValue(int scoreIndex, NodeTopDocs nodeTopDocs) {
        Object[] keys = nodeTopDocs.keys;
        if (keys != null && keys.length > 0) {
            return (E)this.cache.get(keys[scoreIndex]);
        }
        return (E)nodeTopDocs.projections[scoreIndex];
    }

    @Override
    public final boolean hasNext() {
        int nextIndex = this.currentIndex + 1;
        return this.firstResult + nextIndex < this.resultSize && nextIndex < this.maxResults;
    }
}

