/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client;

import java.time.Instant;
import java.util.Date;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.BaseProtoStreamMarshaller;
import org.junit.Assert;
import org.junit.Test;

public class BaseProtoStreamMarshallerTest {
    @Test
    public void testBasicTypesAreMarshallable() throws Exception {
        this.roundtrip("a");
        this.roundtrip(Character.valueOf('a'));
        this.roundtrip(0);
        this.roundtrip(0L);
        this.roundtrip(0.0);
        this.roundtrip(Float.valueOf(0.0f));
        this.roundtrip((byte)0);
        this.roundtrip((short)0);
        this.roundtrip(true);
        this.roundtrip(new Date(0L));
        this.roundtrip(Instant.now());
        this.roundtrip(new byte[0]);
    }

    private void roundtrip(Object in) throws Exception {
        BaseProtoStreamMarshaller marshaller = this.makeInstance();
        Assert.assertTrue((boolean)marshaller.isMarshallable(in));
        byte[] buffer = marshaller.objectToByteBuffer(in);
        Assert.assertNotNull((Object)buffer);
        Object out = marshaller.objectFromByteBuffer(buffer);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals(in.getClass(), out.getClass());
        if (in instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])in), (byte[])((byte[])out));
        } else {
            Assert.assertEquals((Object)in, (Object)out);
        }
    }

    private BaseProtoStreamMarshaller makeInstance() {
        return new BaseProtoStreamMarshaller(){
            private final SerializationContext serCtx = ProtobufUtil.newSerializationContext();

            protected SerializationContext getSerializationContext() {
                return this.serCtx;
            }
        };
    }
}

