/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.dataconversion;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.util.logging.Log;

public class ProtostreamJsonTranscoder
implements Transcoder {
    private static final Log log = (Log)LogFactory.getLog(ProtostreamJsonTranscoder.class, Log.class);
    private final Set<MediaType> supportedTypes;
    private final SerializationContext ctx;

    public ProtostreamJsonTranscoder(SerializationContext ctx) {
        this.ctx = ctx;
        this.supportedTypes = new HashSet<MediaType>();
        this.supportedTypes.add(MediaType.APPLICATION_JSON);
        this.supportedTypes.add(MediaType.APPLICATION_PROTOSTREAM);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_JSON)) {
                String converted = ProtobufUtil.toCanonicalJSON((ImmutableSerializationContext)this.ctx, (byte[])((byte[])content));
                String convertType = destinationType.getClassType();
                if (convertType == null) {
                    return StandardConversions.convertCharset((Object)converted, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
                }
                if (destinationType.hasStringType()) {
                    return converted;
                }
            }
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                Reader reader = (content = this.addTypeIfNeeded(content)) instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                return ProtobufUtil.fromCanonicalJSON((ImmutableSerializationContext)this.ctx, (Reader)reader);
            }
        }
        catch (IOException e) {
            throw log.errorTranscoding((Throwable)e);
        }
        throw log.unsupportedContent(content);
    }

    private Object addTypeIfNeeded(Object content) {
        String wrapped = "{ \"_type\":\"%s\", \"_value\":\"%s\"}";
        if (content instanceof Integer || content instanceof Short) {
            return String.format(wrapped, "int32", content);
        }
        if (content instanceof Long) {
            return String.format(wrapped, "int64", content);
        }
        if (content instanceof Double) {
            return String.format(wrapped, "double", content);
        }
        if (content instanceof Float) {
            return String.format(wrapped, "float", content);
        }
        if (content instanceof Boolean) {
            return String.format(wrapped, "bool", content);
        }
        if (content instanceof String && !content.toString().contains("_type")) {
            return String.format(wrapped, "string", content);
        }
        return content;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedTypes;
    }
}

