/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.ProtostreamSerializationContextInitializer;
import org.infinispan.query.remote.client.impl.Externalizers;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.impl.DefaultQuerySerializer;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.JsonQuerySerializer;
import org.infinispan.query.remote.impl.ObjectRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerInterceptor;
import org.infinispan.query.remote.impl.ProtobufRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.filter.ContinuousQueryResultExternalizer;
import org.infinispan.query.remote.impl.filter.FilterResultExternalizer;
import org.infinispan.query.remote.impl.filter.IckleBinaryProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.filter.IckleContinuousQueryProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapperSearchWorkCreator;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.query.remote.impl.persistence.PersistenceContextInitializerImpl;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.server.core.dataconversion.ProtostreamJsonTranscoder;
import org.infinispan.server.core.dataconversion.ProtostreamObjectTranscoder;
import org.infinispan.server.core.dataconversion.ProtostreamTextTranscoder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;

@InfinispanModule(name="remote-query-server", requiredModules={"core"})
public final class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private MBeanServer mbeanServer;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_CACHE_EVENT_FILTER_CONVERTER, new IckleProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_FILTER_AND_CONVERTER, new IckleProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_BINARY_PROTOBUF_FILTER_AND_CONVERTER, new IckleBinaryProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new FilterResultExternalizer());
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        PersistenceMarshaller persistenceMarshaller = (PersistenceMarshaller)bcr.getComponent("org.infinispan.marshaller.persistence", PersistenceMarshaller.class).wired();
        persistenceMarshaller.register((SerializationContextInitializer)new PersistenceContextInitializerImpl());
        InternalCacheRegistry icr = (InternalCacheRegistry)bcr.getComponent(InternalCacheRegistry.class).running();
        this.registerProtobufMetadataCache(icr, globalCfg);
        this.initProtobufMetadataManager(globalCfg, gcr, bcr);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        cacheManager.getClassWhiteList().addClasses(new Class[]{QueryRequest.class, Externalizers.QueryRequestExternalizer.class});
    }

    private void initProtobufMetadataManager(GlobalConfiguration globalCfg, GlobalComponentRegistry gcr, BasicComponentRegistry bcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        bcr.registerComponent(ProtobufMetadataManager.class, (Object)protobufMetadataManager, true).running();
        if (globalCfg.globalJmxStatistics().enabled()) {
            this.registerProtobufMetadataManagerMBean(protobufMetadataManager, gcr);
        }
        SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
        ClassLoader classLoader = globalCfg.classLoader();
        this.processProtostreamSerializationContextInitializers(classLoader, serCtx);
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        encoderRegistry.registerWrapper((Wrapper)ProtobufWrapper.INSTANCE);
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamJsonTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamTextTranscoder(serCtx));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamObjectTranscoder(serCtx, classLoader));
    }

    private void processProtostreamSerializationContextInitializers(ClassLoader classLoader, SerializationContext serCtx) {
        Collection initializers = ServiceFinder.load(ProtostreamSerializationContextInitializer.class, (ClassLoader[])new ClassLoader[]{classLoader});
        for (ProtostreamSerializationContextInitializer psci : initializers) {
            try {
                psci.init(serCtx);
            }
            catch (Exception e) {
                throw log.errorInitializingSerCtx(e);
            }
        }
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManagerImpl protobufMetadataManager, GlobalComponentRegistry gcr) {
        GlobalJmxStatisticsConfiguration jmxConfig = gcr.getGlobalConfiguration().globalJmxStatistics();
        if (this.mbeanServer == null) {
            this.mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
        }
        String groupName = "type=RemoteQuery,name=" + ObjectName.quote(jmxConfig.cacheManagerName());
        String jmxDomain = JmxUtil.buildJmxDomain((String)jmxConfig.domain(), (MBeanServer)this.mbeanServer, (String)groupName);
        BasicComponentRegistry basicComponentRegistry = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        MBeanMetadata metadata = basicComponentRegistry.getMBeanMetadata(ProtobufMetadataManagerImpl.class.getName());
        try {
            ResourceDMBean mBean = new ResourceDMBean((Object)protobufMetadataManager, metadata, null);
            ObjectName objName = new ObjectName(jmxDomain + ":" + groupName + ",component=" + metadata.getJmxObjectName());
            protobufMetadataManager.setObjectName(objName);
            JmxUtil.registerMBean((Object)mBean, (ObjectName)objName, (MBeanServer)this.mbeanServer);
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        if (gcr.getGlobalConfiguration().globalJmxStatistics().enabled()) {
            this.unregisterProtobufMetadataManagerMBean(gcr);
        }
    }

    private void unregisterProtobufMetadataManagerMBean(GlobalComponentRegistry gcr) {
        if (this.mbeanServer != null) {
            try {
                ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)gcr.getComponent(ProtobufMetadataManager.class);
                if (protobufMetadataManager != null) {
                    JmxUtil.unregisterMBean((ObjectName)protobufMetadataManager.getObjectName(), (MBeanServer)this.mbeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Unable to unregister ProtobufMetadataManager MBean", (Throwable)e);
            }
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr;
        BasicComponentRegistry gcr = (BasicComponentRegistry)cr.getGlobalComponentRegistry().getComponent(BasicComponentRegistry.class);
        if ("___protobuf_metadata".equals(cacheName)) {
            BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
            ProtobufMetadataManagerInterceptor protobufInterceptor = new ProtobufMetadataManagerInterceptor();
            bcr.registerComponent(ProtobufMetadataManagerInterceptor.class, (Object)protobufInterceptor, true);
            bcr.addDynamicDependency(AsyncInterceptorChain.class.getName(), ProtobufMetadataManagerInterceptor.class.getName());
            ((AsyncInterceptorChain)bcr.getComponent(AsyncInterceptorChain.class).wired()).addInterceptorAfter((AsyncInterceptor)protobufInterceptor, EntryWrappingInterceptor.class);
        }
        if (!(icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class).running()).isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addCacheDependency(cacheName);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr);
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
        }
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr) {
        boolean isObjectStorage;
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        MediaType valueStorageMediaType = valueEncoding.mediaType();
        MediaType storageMediaType = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache().getValueDataConversion().getStorageMediaType();
        QuerySerializers querySerializers = this.buildQuerySerializers(cr, storageMediaType);
        boolean bl = isObjectStorage = valueStorageMediaType != null && valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
        if (isObjectStorage) {
            return new ObjectRemoteQueryManager(cr, querySerializers);
        }
        return new ProtobufRemoteQueryManager(ctx, cr, querySerializers);
    }

    private QuerySerializers buildQuerySerializers(ComponentRegistry cr, MediaType storageMediaType) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        QuerySerializers querySerializers = new QuerySerializers();
        DefaultQuerySerializer defaultQuerySerializer = new DefaultQuerySerializer(encoderRegistry);
        querySerializers.addSerializer(MediaType.MATCH_ALL, defaultQuerySerializer);
        if (encoderRegistry.isConversionSupported(storageMediaType, MediaType.APPLICATION_JSON)) {
            Transcoder jsonStorage = encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, storageMediaType);
            Transcoder jsonObject = encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, MediaType.APPLICATION_OBJECT);
            querySerializers.addSerializer(MediaType.APPLICATION_JSON, new JsonQuerySerializer(storageMediaType, jsonStorage, jsonObject));
        }
        return querySerializers;
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        InternalCacheRegistry icr = (InternalCacheRegistry)cr.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (!icr.isInternalCache(cacheName)) {
            Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)cr.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            if (cfg.indexing().index().isEnabled()) {
                log.debugf("Wrapping the SearchWorkCreator for indexed cache %s", cacheName);
                QueryInterceptor queryInterceptor = (QueryInterceptor)cr.getComponent(QueryInterceptor.class);
                queryInterceptor.setSearchWorkCreator(new ProtobufValueWrapperSearchWorkCreator(queryInterceptor.getSearchWorkCreator(), serCtx).get());
            }
        }
    }

    public void cacheManagerStopped(GlobalComponentRegistry gcr) {
        this.mbeanServer = null;
    }

    private void registerProtobufMetadataCache(InternalCacheRegistry internalCacheRegistry, GlobalConfiguration globalConfiguration) {
        internalCacheRegistry.registerInternalCache("___protobuf_metadata", this.getProtobufMetadataCacheConfig(globalConfiguration).build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED, InternalCacheRegistry.Flag.PERSISTENT));
    }

    private ConfigurationBuilder getProtobufMetadataCacheConfig(GlobalConfiguration globalConfiguration) {
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().transaction().lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).clustering().cacheMode(cacheMode).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        if (globalConfiguration.security().authorization().enabled()) {
            globalConfiguration.security().authorization().roles().put("___schema_manager", new CacheRoleImpl("___schema_manager", new AuthorizationPermission[]{AuthorizationPermission.ALL}));
            cfg.security().authorization().enable().role("___schema_manager");
        }
        return cfg;
    }
}

