/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.impl.QuerySerializer;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.RemoteQueryResult;

abstract class BaseRemoteQueryManager
implements RemoteQueryManager {
    final AdvancedCache<?, ?> cache;
    final QuerySerializers querySerializers;
    final DataConversion keyDataConversion;
    final DataConversion valueDataConversion;

    BaseRemoteQueryManager(ComponentRegistry cr, QuerySerializers querySerializers) {
        this.cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        this.querySerializers = querySerializers;
        this.keyDataConversion = this.cache.getKeyDataConversion();
        this.valueDataConversion = this.cache.getValueDataConversion();
    }

    @Override
    public byte[] executeQuery(String queryString, Map<String, Object> namedParametersMap, Integer offset, Integer maxResults, IndexedQueryMode queryMode, AdvancedCache cache, MediaType outputFormat) {
        QuerySerializer<?> querySerializer = this.querySerializers.getSerializer(outputFormat);
        Query query = this.getQueryEngine(cache).makeQuery(queryString, namedParametersMap, offset.intValue(), maxResults, queryMode);
        List results = query.list();
        int totalResults = query.getResultSize();
        String[] projection = query.getProjection();
        RemoteQueryResult remoteQueryResult = new RemoteQueryResult(projection, totalResults, results);
        Object response = querySerializer.createQueryResponse(remoteQueryResult);
        return querySerializer.encodeQueryResponse(response, outputFormat);
    }

    @Override
    public Object convertKey(Object key, MediaType destinationFormat) {
        DataConversion keyDataConversion = this.getKeyDataConversion();
        MediaType storageMediaType = keyDataConversion.getStorageMediaType();
        return keyDataConversion.convert(key, storageMediaType, destinationFormat);
    }

    @Override
    public Object convertValue(Object value, MediaType destinationFormat) {
        DataConversion valueDataConversion = this.getValueDataConversion();
        MediaType storageMediaType = valueDataConversion.getStorageMediaType();
        return valueDataConversion.convert(value, storageMediaType, destinationFormat);
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType requestType) {
        return this.querySerializers.getSerializer(requestType).decodeQueryRequest(queryRequest, requestType);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }
}

