/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.function.BiFunction;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class ProtobufFieldIndexingMetadata
implements IndexedFieldProvider.FieldIndexingMetadata {
    private final Descriptor messageDescriptor;
    private final boolean isLegacyIndexingEnabled;

    ProtobufFieldIndexingMetadata(Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.messageDescriptor = messageDescriptor;
        this.isLegacyIndexingEnabled = IndexingMetadata.isLegacyIndexingEnabled(messageDescriptor);
    }

    public boolean isIndexed(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldIndexed, this.isLegacyIndexingEnabled);
    }

    public boolean isAnalyzed(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldAnalyzed, false);
    }

    public boolean isStored(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldStored, this.isLegacyIndexingEnabled);
    }

    public Object getNullMarker(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            if (i == propertyPath.length) {
                IndexingMetadata indexingMetadata = (IndexingMetadata)md.getProcessedAnnotation("Indexed");
                return indexingMetadata == null ? null : indexingMetadata.getNullMarker(field.getName());
            }
            if (field.getJavaType() != JavaType.MESSAGE) break;
            md = field.getMessageType();
        }
        return null;
    }

    private boolean getFlag(String[] propertyPath, BiFunction<IndexingMetadata, String, Boolean> metadataFun, boolean defVal) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            boolean res;
            ++i;
            FieldDescriptor field = md.findFieldByName(p);
            if (field == null) break;
            IndexingMetadata indexingMetadata = (IndexingMetadata)md.getProcessedAnnotation("Indexed");
            boolean bl = res = indexingMetadata == null ? defVal : metadataFun.apply(indexingMetadata, field.getName());
            if (!res) break;
            if (field.getJavaType() != JavaType.MESSAGE) {
                return i == propertyPath.length;
            }
            md = field.getMessageType();
        }
        return false;
    }
}

