/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.objectfilter.impl.syntax.parser.ReflectionEntityNamesResolver;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.remote.impl.BaseRemoteQueryManager;
import org.infinispan.query.remote.impl.ObjectRemoteQueryEngine;
import org.infinispan.query.remote.impl.ProtobufEntityNameResolver;
import org.infinispan.query.remote.impl.ProtobufObjectReflectionMatcher;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.SecurityActions;

final class ObjectRemoteQueryManager
extends BaseRemoteQueryManager {
    private final Map<String, ObjectRemoteQueryEngine> enginePerMediaType = new ConcurrentHashMap<String, ObjectRemoteQueryEngine>();
    private final SerializationContext serCtx;
    private final SearchIntegrator searchIntegrator;
    private final ComponentRegistry cr;

    ObjectRemoteQueryManager(AdvancedCache<?, ?> cache, ComponentRegistry cr, QuerySerializers querySerializers) {
        super(cache, querySerializers);
        this.cr = cr;
        this.searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        this.serCtx = SecurityActions.getSerializationContext(cache.getCacheManager());
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ObjectReflectionMatcher objectReflectionMatcher = ObjectReflectionMatcher.create((EntityNameResolver)this.createEntityNamesResolver(MediaType.APPLICATION_OBJECT), (SearchIntegrator)this.searchIntegrator);
        bcr.replaceComponent(ObjectReflectionMatcher.class.getName(), (Object)objectReflectionMatcher, true);
        ProtobufObjectReflectionMatcher protobufObjectReflectionMatcher = ProtobufObjectReflectionMatcher.create(this.createEntityNamesResolver(MediaType.APPLICATION_PROTOSTREAM), this.serCtx, this.searchIntegrator);
        bcr.registerComponent(ProtobufObjectReflectionMatcher.class, (Object)protobufObjectReflectionMatcher, true);
    }

    @Override
    public Class<? extends Matcher> getMatcherClass(MediaType mediaType) {
        return this.getQueryEngineForMediaType(mediaType).getMatcherClass();
    }

    @Override
    public ObjectRemoteQueryEngine getQueryEngine(AdvancedCache<?, ?> cache) {
        return this.getQueryEngineForMediaType(cache.getValueDataConversion().getRequestMediaType());
    }

    @Override
    public Object encodeFilterResult(Object filterResult) {
        return filterResult;
    }

    private ObjectRemoteQueryEngine getQueryEngineForMediaType(MediaType mediaType) {
        ObjectRemoteQueryEngine queryEngine = this.enginePerMediaType.get(mediaType.getTypeSubtype());
        if (queryEngine == null) {
            ReflectionMatcher matcher = mediaType.match(MediaType.APPLICATION_PROTOSTREAM) ? (ReflectionMatcher)this.cr.getComponent(ProtobufObjectReflectionMatcher.class) : (ReflectionMatcher)this.cr.getComponent(ObjectReflectionMatcher.class);
            queryEngine = new ObjectRemoteQueryEngine(this.cache, this.searchIntegrator != null, matcher.getClass());
            this.enginePerMediaType.put(mediaType.getTypeSubtype(), queryEngine);
        }
        return queryEngine;
    }

    private EntityNameResolver createEntityNamesResolver(MediaType mediaType) {
        if (mediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            return new ProtobufEntityNameResolver(this.serCtx);
        }
        ClassLoader classLoader = (ClassLoader)this.cr.getGlobalComponentRegistry().getComponent(ClassLoader.class);
        ReflectionEntityNamesResolver reflectionEntityNamesResolver = new ReflectionEntityNamesResolver(classLoader);
        if (this.searchIntegrator != null) {
            QueryInterceptor queryInterceptor = (QueryInterceptor)this.cr.getComponent(QueryInterceptor.class);
            return name -> queryInterceptor.getKnownClasses().stream().filter(c -> c.getName().equals(name)).findFirst().orElse(reflectionEntityNamesResolver.resolve(name));
        }
        return reflectionEntityNamesResolver;
    }
}

