/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.BooleanBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.nulls.codec.impl.LuceneIntegerNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneLongNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.LuceneStringNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;

public final class FieldMapping {
    private static final NullMarkerCodec NOT_ENCODING_NULL = new NullMarkerCodec(){

        public NullMarker getNullMarker() {
            return null;
        }

        public void encodeNullValue(String fieldName, Document document, LuceneOptions luceneOptions) {
        }

        public Query createNullMatchingQuery(String fieldName) {
            throw new IllegalStateException("Cannot build IS NULL query for field '" + fieldName + "' which does not have indexNullAs configured for indexing null values.");
        }

        public boolean representsNullValue(IndexableField field) {
            return field == null;
        }
    };
    private static final LuceneStringNullMarkerCodec STRING_NULL_MARKER_CODEC = new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker((Object)"_null_"));
    private static final FieldBridge DOUBLE_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.DOUBLE_FIELD_BRIDGE, (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private static final FieldBridge FLOAT_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.FLOAT_FIELD_BRIDGE, (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private static final FieldBridge LONG_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.LONG_FIELD_BRIDGE, (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private static final FieldBridge INT_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.INT_FIELD_BRIDGE, (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private static final FieldBridge STRING_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private static final FieldBridge BOOL_FIELD_BRIDGE = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)new BooleanBridge()), (NullMarkerCodec)STRING_NULL_MARKER_CODEC);
    private final String name;
    private final boolean index;
    private final float boost;
    private final boolean analyze;
    private final boolean store;
    private final boolean sortable;
    private final String analyzer;
    private final String indexNullAs;
    private final LuceneOptions luceneOptions;
    private final FieldDescriptor fieldDescriptor;
    private volatile boolean isInitialized = false;
    private Object indexNullAsObj;
    private FieldBridge fieldBridge;

    FieldMapping(String name, boolean index, float boost, boolean analyze, boolean store, boolean sortable, String analyzer, String indexNullAs, LuceneOptions luceneOptions, FieldDescriptor fieldDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException("name argument cannot be null");
        }
        if (luceneOptions == null) {
            throw new IllegalArgumentException("luceneOptions argument cannot be null");
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException("fieldDescriptor argument cannot be null");
        }
        this.name = name;
        this.index = index;
        this.boost = boost;
        this.analyze = analyze;
        this.store = store;
        this.sortable = sortable;
        this.analyzer = analyzer;
        this.indexNullAs = indexNullAs;
        this.fieldDescriptor = fieldDescriptor;
        this.luceneOptions = luceneOptions;
    }

    public String name() {
        return this.name;
    }

    public boolean index() {
        return this.index;
    }

    public float boost() {
        return this.boost;
    }

    public boolean analyze() {
        return this.analyze;
    }

    public boolean store() {
        return this.store;
    }

    public boolean sortable() {
        return this.sortable;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public LuceneOptions luceneOptions() {
        return this.luceneOptions;
    }

    public Object indexNullAs() {
        this.init();
        return this.indexNullAsObj;
    }

    public FieldBridge fieldBridge() {
        this.init();
        return this.fieldBridge;
    }

    private void init() {
        if (!this.isInitialized) {
            if (this.fieldDescriptor.getType() == null) {
                throw new IllegalStateException("FieldDescriptors are not fully initialised!");
            }
            this.indexNullAsObj = this.parseIndexNullAs();
            this.fieldBridge = this.makeFieldBridge();
            this.isInitialized = true;
        }
    }

    private Object parseIndexNullAs() {
        if (this.indexNullAs != null) {
            switch (this.fieldDescriptor.getType()) {
                case DOUBLE: {
                    return Double.parseDouble(this.indexNullAs);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(this.indexNullAs));
                }
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case SFIXED64: 
                case SINT64: {
                    return Long.parseLong(this.indexNullAs);
                }
                case INT32: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SINT32: {
                    return Integer.parseInt(this.indexNullAs);
                }
                case ENUM: {
                    EnumValueDescriptor enumVal = this.fieldDescriptor.getEnumType().findValueByName(this.indexNullAs);
                    if (enumVal == null) {
                        throw new IllegalArgumentException("Enum value not found : " + this.indexNullAs);
                    }
                    return enumVal.getNumber();
                }
                case BOOL: {
                    return Boolean.valueOf(this.indexNullAs);
                }
            }
        }
        return this.indexNullAs;
    }

    private FieldBridge makeFieldBridge() {
        switch (this.fieldDescriptor.getType()) {
            case DOUBLE: {
                return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.DOUBLE_FIELD_BRIDGE, NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.DOUBLE_FIELD_BRIDGE, (NullMarkerCodec)new LuceneLongNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
            }
            case FLOAT: {
                return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.FLOAT_FIELD_BRIDGE, NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.FLOAT_FIELD_BRIDGE, (NullMarkerCodec)new LuceneLongNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.LONG_FIELD_BRIDGE, NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.LONG_FIELD_BRIDGE, (NullMarkerCodec)new LuceneLongNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
            }
            case INT32: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SINT32: 
            case ENUM: {
                return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.INT_FIELD_BRIDGE, NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)NumericFieldBridge.INT_FIELD_BRIDGE, (NullMarkerCodec)new LuceneIntegerNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
            }
            case BOOL: {
                return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)new BooleanBridge()), NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)new BooleanBridge()), (NullMarkerCodec)new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
            }
        }
        return this.indexNullAsObj == null ? new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), NOT_ENCODING_NULL) : new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), (NullMarkerCodec)new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker(this.indexNullAsObj)));
    }

    public static FieldBridge getDefaultFieldBridge(Type type) {
        switch (type) {
            case DOUBLE: {
                return DOUBLE_FIELD_BRIDGE;
            }
            case FLOAT: {
                return FLOAT_FIELD_BRIDGE;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                return LONG_FIELD_BRIDGE;
            }
            case INT32: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SINT32: 
            case ENUM: {
                return INT_FIELD_BRIDGE;
            }
            case BOOL: {
                return BOOL_FIELD_BRIDGE;
            }
            case STRING: 
            case BYTES: 
            case GROUP: 
            case MESSAGE: {
                return STRING_FIELD_BRIDGE;
            }
        }
        return null;
    }

    public String toString() {
        return "FieldMapping{name='" + this.name + '\'' + ", index=" + this.index + ", boost=" + this.boost + ", analyze=" + this.analyze + ", store=" + this.store + ", sortable=" + this.sortable + ", analyzer='" + this.analyzer + '\'' + ", indexNullAs=" + this.indexNullAs + ", luceneOptions=" + this.luceneOptions + '}';
    }
}

