/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.IndexingTagHandler;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;

final class IndexingWrappedMessageTagHandler
extends WrappedMessageTagHandler {
    private final Document document;
    private final LuceneOptions luceneOptions;

    IndexingWrappedMessageTagHandler(ProtobufValueWrapper valueWrapper, SerializationContext serCtx, Document document, LuceneOptions luceneOptions) {
        super(valueWrapper, serCtx);
        this.document = document;
        this.luceneOptions = luceneOptions;
    }

    @Override
    public void onEnd() {
        super.onEnd();
        if (this.messageBytes != null) {
            Descriptor descriptor = this.valueWrapper.getMessageDescriptor();
            IndexingMetadata indexingMetadata = (IndexingMetadata)descriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && indexingMetadata.isIndexed()) {
                try {
                    ProtobufParser.INSTANCE.parse((TagHandler)new IndexingTagHandler(descriptor, this.document), descriptor, this.messageBytes);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        } else if (this.numericValue != null) {
            this.luceneOptions.addNumericFieldToDocument("$$value$$", (Object)this.numericValue, this.document);
        } else if (this.stringValue != null) {
            this.luceneOptions.addFieldToDocument("$$value$$", this.stringValue, this.document);
        }
    }
}

