/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.IndexingWrappedMessageTagHandler;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.SecurityActions;
import org.infinispan.query.remote.impl.logging.Log;

public final class ProtobufValueWrapperFieldBridge
implements FieldBridge {
    private static final Log log = (Log)LogFactory.getLog(ProtobufValueWrapperFieldBridge.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache cache;
    private SerializationContext serializationContext = null;
    private Descriptor wrapperDescriptor = null;

    public ProtobufValueWrapperFieldBridge(Cache cache) {
        this.cache = cache;
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (trace) {
            log.tracef("Setting Lucene document properties for %s in cache %s", value.toString(), this.cache.getName());
        }
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)value;
        this.decodeAndIndex(valueWrapper, document, luceneOptions);
    }

    private void decodeAndIndex(ProtobufValueWrapper valueWrapper, Document document, LuceneOptions luceneOptions) {
        if (this.serializationContext == null) {
            this.serializationContext = SecurityActions.getSerializationContext(this.cache.getCacheManager());
            this.wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        }
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)new IndexingWrappedMessageTagHandler(valueWrapper, this.serializationContext, document, luceneOptions), this.wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

