/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.impl.QuerySerializer;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.RemoteQueryResult;
import org.infinispan.query.remote.json.Hit;
import org.infinispan.query.remote.json.JsonQueryResponse;
import org.infinispan.query.remote.json.JsonQueryResult;
import org.infinispan.query.remote.json.ProjectedJsonResult;

class JsonQuerySerializer
implements QuerySerializer<JsonQueryResponse> {
    private final MediaType storageMediaTye;
    private final Transcoder transcoderFromStorage;
    private final Transcoder transcoderToObject;

    JsonQuerySerializer(MediaType storageMediaTye, Transcoder transcoderFromStorage, Transcoder transcoderToObject) {
        this.storageMediaTye = storageMediaTye;
        this.transcoderFromStorage = transcoderFromStorage;
        this.transcoderToObject = transcoderToObject;
    }

    @Override
    public QueryRequest decodeQueryRequest(byte[] queryRequest, MediaType mediaType) {
        return (QueryRequest)this.transcoderToObject.transcode((Object)queryRequest, mediaType, RemoteQueryManager.QUERY_REQUEST_TYPE);
    }

    @Override
    public JsonQueryResponse createQueryResponse(RemoteQueryResult remoteQueryResult) {
        JsonQueryResponse response;
        long totalResults = remoteQueryResult.getTotalResults();
        String[] projections = remoteQueryResult.getProjections();
        if (projections == null) {
            List results = remoteQueryResult.getResults().stream().map(o -> this.transcoderFromStorage.transcode(o, this.storageMediaTye, MediaType.APPLICATION_JSON)).collect(Collectors.toList());
            List<Hit> hits = results.stream().map(Hit::new).collect(Collectors.toList());
            response = new JsonQueryResult(hits, totalResults);
        } else {
            response = new ProjectedJsonResult(totalResults, projections, remoteQueryResult.getResults());
        }
        return response;
    }

    @Override
    public byte[] encodeQueryResponse(Object queryResponse, MediaType destinationType) {
        return ((JsonQueryResponse)queryResponse).toJson().toString().getBytes(StandardCharsets.UTF_8);
    }
}

