/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping;

import java.util.Arrays;
import java.util.Set;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingKeyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.ProgrammaticMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.impl.CacheRoutingKeyBridge;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.impl.indexing.ProtobufEntityConverter;
import org.infinispan.query.remote.impl.mapping.model.ProtobufBootstrapIntrospector;
import org.infinispan.query.remote.impl.mapping.reference.GlobalReferenceHolder;
import org.infinispan.query.remote.impl.mapping.typebridge.ProtobufMessageBinder;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.mapping.SearchMappingBuilder;
import org.infinispan.search.mapper.mapping.SearchMappingHolder;

public class SerializationContextSearchMapping {
    private static final String[] EXCLUDE_CACHE_NAMES = new String[]{"___script_cache", "___protobuf_metadata"};
    private final SerializationContext serializationContext;

    public static SerializationContextSearchMapping acquire(SerializationContext serializationContext) {
        return new SerializationContextSearchMapping(serializationContext);
    }

    private SerializationContextSearchMapping(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    public void updateSearchMappingHolders(EmbeddedCacheManager cacheManager) {
        for (String cacheName : cacheManager.getCacheConfigurationNames()) {
            Cache cache;
            SearchMappingHolder searchMappingHolder;
            if (Arrays.asList(EXCLUDE_CACHE_NAMES).contains(cacheName) || !cacheManager.isRunning(cacheName) || (searchMappingHolder = ComponentRegistryUtils.getSearchMappingHolder((Cache)(cache = cacheManager.getCache(cacheName)))) == null) continue;
            this.buildMapping(searchMappingHolder, cache.getCacheConfiguration().indexing().indexedEntityTypes());
        }
    }

    public void buildMapping(SearchMappingHolder mappingHolder, Set<String> indexedEntityTypes) {
        GlobalReferenceHolder globalReferenceHolder = new GlobalReferenceHolder(this.serializationContext.getGenericDescriptors());
        ProtobufBootstrapIntrospector introspector = new ProtobufBootstrapIntrospector();
        SearchMappingBuilder builder = mappingHolder.builder((PojoBootstrapIntrospector)introspector);
        builder.setEntityConverter((EntityConverter)new ProtobufEntityConverter(this.serializationContext, globalReferenceHolder.getRootMessages()));
        ProgrammaticMappingConfigurationContext programmaticMapping = builder.programmaticMapping();
        if (globalReferenceHolder.getRootMessages().isEmpty()) {
            return;
        }
        boolean existIndexedEntities = false;
        for (GlobalReferenceHolder.RootMessageInfo rootMessage : globalReferenceHolder.getRootMessages()) {
            String fullName = rootMessage.getFullName();
            if (!indexedEntityTypes.contains(fullName)) continue;
            existIndexedEntities = true;
            programmaticMapping.type(fullName).binder((TypeBinder)new ProtobufMessageBinder(globalReferenceHolder, fullName)).routingKeyBinder((RoutingKeyBinder)new CacheRoutingKeyBridge.Binder()).indexed().index(rootMessage.getIndexName());
            builder.addEntityType(byte[].class, fullName);
        }
        if (existIndexedEntities) {
            mappingHolder.build();
        }
    }
}

