/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.json;

import java.util.Map;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.query.dsl.IndexedQueryMode;

public class JsonQueryRequest
implements JsonSerialization {
    private static final Integer DEFAULT_OFFSET = 0;
    private static final Integer DEFAULT_MAX_RESULTS = 10;
    private final String query;
    private final Integer startOffset;
    private final Integer maxResults;
    private final IndexedQueryMode queryMode;

    public JsonQueryRequest(String query, Integer startOffset, Integer maxResults, IndexedQueryMode queryMode) {
        this.query = query;
        this.startOffset = startOffset == null ? DEFAULT_OFFSET : startOffset;
        this.maxResults = maxResults == null ? DEFAULT_MAX_RESULTS : maxResults;
        this.queryMode = queryMode;
    }

    private JsonQueryRequest(String query) {
        this(query, DEFAULT_OFFSET, DEFAULT_MAX_RESULTS, null);
    }

    private JsonQueryRequest() {
        this("");
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getStartOffset() {
        return this.startOffset;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public IndexedQueryMode getQueryMode() {
        return this.queryMode;
    }

    public Json toJson() {
        throw new UnsupportedOperationException();
    }

    public static JsonQueryRequest fromJson(String json) {
        Map properties = Json.read((String)json).asJsonMap();
        Json queryValue = (Json)properties.get("query");
        Json offsetValue = (Json)properties.get("offset");
        Json maxResultsValue = (Json)properties.get("max_results");
        Json queryModeValue = (Json)properties.get("query_mode");
        String query = queryValue != null ? queryValue.asString() : null;
        Integer offset = offsetValue != null ? Integer.valueOf(offsetValue.asInteger()) : null;
        Integer maxResults = maxResultsValue != null ? Integer.valueOf(maxResultsValue.asInteger()) : null;
        IndexedQueryMode queryMode = queryModeValue != null ? IndexedQueryMode.valueOf((String)queryModeValue.asString()) : null;
        return new JsonQueryRequest(query, offset, maxResults, queryMode);
    }
}

