/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl;

import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.client.impl.Externalizers;
import org.infinispan.query.remote.client.impl.MarshallerRegistration;
import org.infinispan.query.remote.client.impl.QueryRequest;
import org.infinispan.query.remote.impl.DefaultQuerySerializer;
import org.infinispan.query.remote.impl.ExternalizerIds;
import org.infinispan.query.remote.impl.JsonQuerySerializer;
import org.infinispan.query.remote.impl.ObjectRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.query.remote.impl.ProtobufRemoteQueryManager;
import org.infinispan.query.remote.impl.ProtobufWrapper;
import org.infinispan.query.remote.impl.QuerySerializers;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.impl.filter.ContinuousQueryResultExternalizer;
import org.infinispan.query.remote.impl.filter.FilterResultExternalizer;
import org.infinispan.query.remote.impl.filter.IckleBinaryProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.filter.IckleContinuousQueryProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufCacheEventFilterConverter;
import org.infinispan.query.remote.impl.filter.IckleProtobufFilterAndConverter;
import org.infinispan.query.remote.impl.logging.Log;
import org.infinispan.query.remote.impl.mapping.SerializationContextSearchMapping;
import org.infinispan.query.remote.impl.persistence.PersistenceContextInitializerImpl;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.search.mapper.mapping.SearchMappingHolder;

@InfinispanModule(name="remote-query-server", requiredModules={"core", "query", "server-core"})
public final class LifecycleManager
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        Map externalizerMap = globalCfg.serialization().advancedExternalizers();
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_CACHE_EVENT_FILTER_CONVERTER, new IckleProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_PROTOBUF_FILTER_AND_CONVERTER, new IckleProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_CACHE_EVENT_FILTER_CONVERTER, new IckleContinuousQueryProtobufCacheEventFilterConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_BINARY_PROTOBUF_FILTER_AND_CONVERTER, new IckleBinaryProtobufFilterAndConverter.Externalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_CONTINUOUS_QUERY_RESULT, new ContinuousQueryResultExternalizer());
        externalizerMap.put(ExternalizerIds.ICKLE_FILTER_RESULT, new FilterResultExternalizer());
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)MarshallerRegistration.INSTANCE);
        this.initProtobufMetadataManager(bcr);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class);
        cacheManager.getClassAllowList().addClasses(new Class[]{QueryRequest.class, Externalizers.QueryRequestExternalizer.class});
    }

    private void initProtobufMetadataManager(BasicComponentRegistry bcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        bcr.registerComponent(ProtobufMetadataManager.class, (Object)protobufMetadataManager, true).running();
        EncoderRegistry encoderRegistry = (EncoderRegistry)bcr.getComponent(EncoderRegistry.class).wired();
        encoderRegistry.registerWrapper((Wrapper)ProtobufWrapper.INSTANCE);
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)bcr.getComponent(ProtobufMetadataManager.class).running();
        protobufMetadataManager.getCache();
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        if (globalCfg.jmx().enabled()) {
            this.registerProtobufMetadataManagerMBean(protobufMetadataManager, globalCfg, bcr);
        }
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManagerImpl protobufMetadataManager, GlobalConfiguration globalConfig, BasicComponentRegistry bcr) {
        CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)bcr.getComponent(CacheManagerJmxRegistration.class).running();
        try {
            jmxRegistration.registerMBean((Object)protobufMetadataManager, this.getRemoteQueryGroupName(globalConfig));
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    private String getRemoteQueryGroupName(GlobalConfiguration globalConfig) {
        return "type=RemoteQuery,name=" + ObjectName.quote(globalConfig.cacheManagerName());
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr;
        BasicComponentRegistry gcr = (BasicComponentRegistry)cr.getGlobalComponentRegistry().getComponent(BasicComponentRegistry.class);
        if ("___protobuf_metadata".equals(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addProtobufMetadataManagerInterceptor((BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class));
        }
        if (!(icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class).running()).isInternalCache(cacheName)) {
            AdvancedCache cache;
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addCacheDependency(cacheName);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            SearchMappingHolder searchMappingHolder = (SearchMappingHolder)cr.getComponent(SearchMappingHolder.class);
            if (searchMappingHolder != null) {
                AdvancedCache cache2 = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache().withStorageMediaType().withWrapping(ByteArrayWrapper.class, ProtobufWrapper.class);
                KeyTransformationHandler keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler((Cache)cache2);
                searchMappingHolder.setEntityLoader((EntityLoader)new org.infinispan.query.impl.EntityLoader(cache2, keyTransformationHandler));
                SerializationContextSearchMapping.acquire(serCtx).buildMapping(searchMappingHolder, cache2.getCacheConfiguration().indexing().indexedEntityTypes());
            }
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr);
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
            if (cfg.indexing().enabled() && (cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache()).getValueDataConversion().getStorageMediaType().match(MediaType.APPLICATION_PROTOSTREAM)) {
                Set knownTypes = protobufMetadataManager.getSerializationContext().getGenericDescriptors().keySet();
                for (String typeName : cfg.indexing().indexedEntityTypes()) {
                    if (knownTypes.contains(typeName)) continue;
                    throw new CacheConfigurationException("The declared indexed type '" + typeName + "' is not known. Please register its proto schema file first.");
                }
            }
        }
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr) {
        boolean isObjectStorage;
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        MediaType valueStorageMediaType = valueEncoding.mediaType();
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        MediaType storageMediaType = cache.getValueDataConversion().getStorageMediaType();
        QuerySerializers querySerializers = this.buildQuerySerializers(cr, storageMediaType);
        boolean bl = isObjectStorage = valueStorageMediaType != null && valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
        if (isObjectStorage) {
            return new ObjectRemoteQueryManager(cache, cr, querySerializers);
        }
        return new ProtobufRemoteQueryManager(cache, cr, ctx, querySerializers);
    }

    private QuerySerializers buildQuerySerializers(ComponentRegistry cr, MediaType storageMediaType) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        QuerySerializers querySerializers = new QuerySerializers();
        DefaultQuerySerializer defaultQuerySerializer = new DefaultQuerySerializer(encoderRegistry);
        querySerializers.addSerializer(MediaType.MATCH_ALL, defaultQuerySerializer);
        if (encoderRegistry.isConversionSupported(storageMediaType, MediaType.APPLICATION_JSON)) {
            Transcoder jsonStorage = encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, storageMediaType);
            querySerializers.addSerializer(MediaType.APPLICATION_JSON, new JsonQuerySerializer(storageMediaType, jsonStorage));
        }
        return querySerializers;
    }
}

